/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an association between a network ACL and a subnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkAclAssociation implements ToCopyableBuilder<NetworkAclAssociation.Builder, NetworkAclAssociation> {
    private final String networkAclAssociationId;

    private final String networkAclId;

    private final String subnetId;

    private NetworkAclAssociation(BuilderImpl builder) {
        this.networkAclAssociationId = builder.networkAclAssociationId;
        this.networkAclId = builder.networkAclId;
        this.subnetId = builder.subnetId;
    }

    /**
     * <p>
     * The ID of the association between a network ACL and a subnet.
     * </p>
     * 
     * @return The ID of the association between a network ACL and a subnet.
     */
    public String networkAclAssociationId() {
        return networkAclAssociationId;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * The ID of the subnet.
     * </p>
     * 
     * @return The ID of the subnet.
     */
    public String subnetId() {
        return subnetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((networkAclAssociationId() == null) ? 0 : networkAclAssociationId().hashCode());
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAclAssociation)) {
            return false;
        }
        NetworkAclAssociation other = (NetworkAclAssociation) obj;
        if (other.networkAclAssociationId() == null ^ this.networkAclAssociationId() == null) {
            return false;
        }
        if (other.networkAclAssociationId() != null && !other.networkAclAssociationId().equals(this.networkAclAssociationId())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (networkAclAssociationId() != null) {
            sb.append("NetworkAclAssociationId: ").append(networkAclAssociationId()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAclAssociation> {
        /**
         * <p>
         * The ID of the association between a network ACL and a subnet.
         * </p>
         * 
         * @param networkAclAssociationId
         *        The ID of the association between a network ACL and a subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclAssociationId(String networkAclAssociationId);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * The ID of the subnet.
         * </p>
         * 
         * @param subnetId
         *        The ID of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);
    }

    private static final class BuilderImpl implements Builder {
        private String networkAclAssociationId;

        private String networkAclId;

        private String subnetId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAclAssociation model) {
            setNetworkAclAssociationId(model.networkAclAssociationId);
            setNetworkAclId(model.networkAclId);
            setSubnetId(model.subnetId);
        }

        public final String getNetworkAclAssociationId() {
            return networkAclAssociationId;
        }

        @Override
        public final Builder networkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
            return this;
        }

        public final void setNetworkAclAssociationId(String networkAclAssociationId) {
            this.networkAclAssociationId = networkAclAssociationId;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        @Override
        public NetworkAclAssociation build() {
            return new NetworkAclAssociation(this);
        }
    }
}
