/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a network ACL.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class NetworkAcl implements ToCopyableBuilder<NetworkAcl.Builder, NetworkAcl> {
    private final List<NetworkAclAssociation> associations;

    private final List<NetworkAclEntry> entries;

    private final Boolean isDefault;

    private final String networkAclId;

    private final List<Tag> tags;

    private final String vpcId;

    private NetworkAcl(BuilderImpl builder) {
        this.associations = builder.associations;
        this.entries = builder.entries;
        this.isDefault = builder.isDefault;
        this.networkAclId = builder.networkAclId;
        this.tags = builder.tags;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Any associations between the network ACL and one or more subnets
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any associations between the network ACL and one or more subnets
     */
    public List<NetworkAclAssociation> associations() {
        return associations;
    }

    /**
     * <p>
     * One or more entries (rules) in the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more entries (rules) in the network ACL.
     */
    public List<NetworkAclEntry> entries() {
        return entries;
    }

    /**
     * <p>
     * Indicates whether this is the default network ACL for the VPC.
     * </p>
     * 
     * @return Indicates whether this is the default network ACL for the VPC.
     */
    public Boolean isDefault() {
        return isDefault;
    }

    /**
     * <p>
     * The ID of the network ACL.
     * </p>
     * 
     * @return The ID of the network ACL.
     */
    public String networkAclId() {
        return networkAclId;
    }

    /**
     * <p>
     * Any tags assigned to the network ACL.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the network ACL.
     */
    public List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The ID of the VPC for the network ACL.
     * </p>
     * 
     * @return The ID of the VPC for the network ACL.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associations() == null) ? 0 : associations().hashCode());
        hashCode = 31 * hashCode + ((entries() == null) ? 0 : entries().hashCode());
        hashCode = 31 * hashCode + ((isDefault() == null) ? 0 : isDefault().hashCode());
        hashCode = 31 * hashCode + ((networkAclId() == null) ? 0 : networkAclId().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkAcl)) {
            return false;
        }
        NetworkAcl other = (NetworkAcl) obj;
        if (other.associations() == null ^ this.associations() == null) {
            return false;
        }
        if (other.associations() != null && !other.associations().equals(this.associations())) {
            return false;
        }
        if (other.entries() == null ^ this.entries() == null) {
            return false;
        }
        if (other.entries() != null && !other.entries().equals(this.entries())) {
            return false;
        }
        if (other.isDefault() == null ^ this.isDefault() == null) {
            return false;
        }
        if (other.isDefault() != null && !other.isDefault().equals(this.isDefault())) {
            return false;
        }
        if (other.networkAclId() == null ^ this.networkAclId() == null) {
            return false;
        }
        if (other.networkAclId() != null && !other.networkAclId().equals(this.networkAclId())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associations() != null) {
            sb.append("Associations: ").append(associations()).append(",");
        }
        if (entries() != null) {
            sb.append("Entries: ").append(entries()).append(",");
        }
        if (isDefault() != null) {
            sb.append("IsDefault: ").append(isDefault()).append(",");
        }
        if (networkAclId() != null) {
            sb.append("NetworkAclId: ").append(networkAclId()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, NetworkAcl> {
        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(Collection<NetworkAclAssociation> associations);

        /**
         * <p>
         * Any associations between the network ACL and one or more subnets
         * </p>
         * 
         * @param associations
         *        Any associations between the network ACL and one or more subnets
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associations(NetworkAclAssociation... associations);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(Collection<NetworkAclEntry> entries);

        /**
         * <p>
         * One or more entries (rules) in the network ACL.
         * </p>
         * 
         * @param entries
         *        One or more entries (rules) in the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entries(NetworkAclEntry... entries);

        /**
         * <p>
         * Indicates whether this is the default network ACL for the VPC.
         * </p>
         * 
         * @param isDefault
         *        Indicates whether this is the default network ACL for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefault(Boolean isDefault);

        /**
         * <p>
         * The ID of the network ACL.
         * </p>
         * 
         * @param networkAclId
         *        The ID of the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAclId(String networkAclId);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the network ACL.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * The ID of the VPC for the network ACL.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC for the network ACL.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private List<NetworkAclAssociation> associations;

        private List<NetworkAclEntry> entries;

        private Boolean isDefault;

        private String networkAclId;

        private List<Tag> tags;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkAcl model) {
            setAssociations(model.associations);
            setEntries(model.entries);
            setIsDefault(model.isDefault);
            setNetworkAclId(model.networkAclId);
            setTags(model.tags);
            setVpcId(model.vpcId);
        }

        public final Collection<NetworkAclAssociation> getAssociations() {
            return associations;
        }

        @Override
        public final Builder associations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(NetworkAclAssociation... associations) {
            associations(Arrays.asList(associations));
            return this;
        }

        public final void setAssociations(Collection<NetworkAclAssociation> associations) {
            this.associations = NetworkAclAssociationListCopier.copy(associations);
        }

        @SafeVarargs
        public final void setAssociations(NetworkAclAssociation... associations) {
            associations(Arrays.asList(associations));
        }

        public final Collection<NetworkAclEntry> getEntries() {
            return entries;
        }

        @Override
        public final Builder entries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entries(NetworkAclEntry... entries) {
            entries(Arrays.asList(entries));
            return this;
        }

        public final void setEntries(Collection<NetworkAclEntry> entries) {
            this.entries = NetworkAclEntryListCopier.copy(entries);
        }

        @SafeVarargs
        public final void setEntries(NetworkAclEntry... entries) {
            entries(Arrays.asList(entries));
        }

        public final Boolean getIsDefault() {
            return isDefault;
        }

        @Override
        public final Builder isDefault(Boolean isDefault) {
            this.isDefault = isDefault;
            return this;
        }

        public final void setIsDefault(Boolean isDefault) {
            this.isDefault = isDefault;
        }

        public final String getNetworkAclId() {
            return networkAclId;
        }

        @Override
        public final Builder networkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
            return this;
        }

        public final void setNetworkAclId(String networkAclId) {
            this.networkAclId = networkAclId;
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public NetworkAcl build() {
            return new NetworkAcl(this);
        }
    }
}
