/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyVolumeRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<ModifyVolumeRequest.Builder, ModifyVolumeRequest> {
    private final String volumeId;

    private final Integer size;

    private final String volumeType;

    private final Integer iops;

    private ModifyVolumeRequest(BuilderImpl builder) {
        this.volumeId = builder.volumeId;
        this.size = builder.size;
        this.volumeType = builder.volumeType;
        this.iops = builder.iops;
    }

    /**
     * Returns the value of the VolumeId property for this object.
     * 
     * @return The value of the VolumeId property for this object.
     */
    public String volumeId() {
        return volumeId;
    }

    /**
     * <p>
     * Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than the
     * existing size of the volume. For information about available EBS volume sizes, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
     * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.
     * </p>
     * <p>
     * Default: If no size is specified, the existing size is retained.
     * </p>
     * 
     * @return Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than
     *         the existing size of the volume. For information about available EBS volume sizes, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
     *         >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.</p>
     *         <p>
     *         Default: If no size is specified, the existing size is retained.
     */
    public Integer size() {
        return size;
    }

    /**
     * <p>
     * Target EBS volume type of the volume to be modified
     * </p>
     * <p>
     * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type of
     * a volume to <code>standard</code>.
     * </p>
     * <p>
     * Default: If no type is specified, the existing type is retained.
     * </p>
     * 
     * @return Target EBS volume type of the volume to be modified</p>
     *         <p>
     *         The API does not support modifications for volume type <code>standard</code>. You also cannot change the
     *         type of a volume to <code>standard</code>.
     *         </p>
     *         <p>
     *         Default: If no type is specified, the existing type is retained.
     * @see VolumeType
     */
    public String volumeType() {
        return volumeType;
    }

    /**
     * <p>
     * Target IOPS rate of the volume to be modified.
     * </p>
     * <p>
     * Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about <code>io1</code> IOPS
     * configuration, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
     * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
     * </p>
     * <p>
     * Default: If no IOPS value is specified, the existing value is retained.
     * </p>
     * 
     * @return Target IOPS rate of the volume to be modified.</p>
     *         <p>
     *         Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about
     *         <code>io1</code> IOPS configuration, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
     *         >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
     *         </p>
     *         <p>
     *         Default: If no IOPS value is specified, the existing value is retained.
     */
    public Integer iops() {
        return iops;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((volumeId() == null) ? 0 : volumeId().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        hashCode = 31 * hashCode + ((volumeType() == null) ? 0 : volumeType().hashCode());
        hashCode = 31 * hashCode + ((iops() == null) ? 0 : iops().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyVolumeRequest)) {
            return false;
        }
        ModifyVolumeRequest other = (ModifyVolumeRequest) obj;
        if (other.volumeId() == null ^ this.volumeId() == null) {
            return false;
        }
        if (other.volumeId() != null && !other.volumeId().equals(this.volumeId())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        if (other.volumeType() == null ^ this.volumeType() == null) {
            return false;
        }
        if (other.volumeType() != null && !other.volumeType().equals(this.volumeType())) {
            return false;
        }
        if (other.iops() == null ^ this.iops() == null) {
            return false;
        }
        if (other.iops() != null && !other.iops().equals(this.iops())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (volumeId() != null) {
            sb.append("VolumeId: ").append(volumeId()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        if (volumeType() != null) {
            sb.append("VolumeType: ").append(volumeType()).append(",");
        }
        if (iops() != null) {
            sb.append("Iops: ").append(iops()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyVolumeRequest> {
        /**
         * Sets the value of the VolumeId property for this object.
         *
         * @param volumeId
         *        The new value for the VolumeId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumeId(String volumeId);

        /**
         * <p>
         * Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to than the
         * existing size of the volume. For information about available EBS volume sizes, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
         * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.
         * </p>
         * <p>
         * Default: If no size is specified, the existing size is retained.
         * </p>
         * 
         * @param size
         *        Target size in GiB of the volume to be modified. Target volume size must be greater than or equal to
         *        than the existing size of the volume. For information about available EBS volume sizes, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html"
         *        >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html</a>.</p>
         *        <p>
         *        Default: If no size is specified, the existing size is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Integer size);

        /**
         * <p>
         * Target EBS volume type of the volume to be modified
         * </p>
         * <p>
         * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type
         * of a volume to <code>standard</code>.
         * </p>
         * <p>
         * Default: If no type is specified, the existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        Target EBS volume type of the volume to be modified</p>
         *        <p>
         *        The API does not support modifications for volume type <code>standard</code>. You also cannot change
         *        the type of a volume to <code>standard</code>.
         *        </p>
         *        <p>
         *        Default: If no type is specified, the existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(String volumeType);

        /**
         * <p>
         * Target EBS volume type of the volume to be modified
         * </p>
         * <p>
         * The API does not support modifications for volume type <code>standard</code>. You also cannot change the type
         * of a volume to <code>standard</code>.
         * </p>
         * <p>
         * Default: If no type is specified, the existing type is retained.
         * </p>
         * 
         * @param volumeType
         *        Target EBS volume type of the volume to be modified</p>
         *        <p>
         *        The API does not support modifications for volume type <code>standard</code>. You also cannot change
         *        the type of a volume to <code>standard</code>.
         *        </p>
         *        <p>
         *        Default: If no type is specified, the existing type is retained.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder volumeType(VolumeType volumeType);

        /**
         * <p>
         * Target IOPS rate of the volume to be modified.
         * </p>
         * <p>
         * Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about <code>io1</code>
         * IOPS configuration, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
         * >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
         * </p>
         * <p>
         * Default: If no IOPS value is specified, the existing value is retained.
         * </p>
         * 
         * @param iops
         *        Target IOPS rate of the volume to be modified.</p>
         *        <p>
         *        Only valid for Provisioned IOPS SSD (<code>io1</code>) volumes. For more information about
         *        <code>io1</code> IOPS configuration, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops"
         *        >http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops</a>.
         *        </p>
         *        <p>
         *        Default: If no IOPS value is specified, the existing value is retained.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iops(Integer iops);
    }

    private static final class BuilderImpl implements Builder {
        private String volumeId;

        private Integer size;

        private String volumeType;

        private Integer iops;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyVolumeRequest model) {
            setVolumeId(model.volumeId);
            setSize(model.size);
            setVolumeType(model.volumeType);
            setIops(model.iops);
        }

        public final String getVolumeId() {
            return volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getSize() {
            return size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getVolumeType() {
            return volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public final void setVolumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
        }

        public final Integer getIops() {
            return iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        @Override
        public ModifyVolumeRequest build() {
            return new ModifyVolumeRequest(this);
        }
    }
}
