/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of ModifyHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ModifyHostsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<ModifyHostsResponse.Builder, ModifyHostsResponse> {
    private final List<String> successful;

    private final List<UnsuccessfulItem> unsuccessful;

    private ModifyHostsResponse(BuilderImpl builder) {
        this.successful = builder.successful;
        this.unsuccessful = builder.unsuccessful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that were successfully modified.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that were successfully modified.
     */
    public List<String> successful() {
        return successful;
    }

    /**
     * <p>
     * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be used.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
     *         used.
     */
    public List<UnsuccessfulItem> unsuccessful() {
        return unsuccessful;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((successful() == null) ? 0 : successful().hashCode());
        hashCode = 31 * hashCode + ((unsuccessful() == null) ? 0 : unsuccessful().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsResponse)) {
            return false;
        }
        ModifyHostsResponse other = (ModifyHostsResponse) obj;
        if (other.successful() == null ^ this.successful() == null) {
            return false;
        }
        if (other.successful() != null && !other.successful().equals(this.successful())) {
            return false;
        }
        if (other.unsuccessful() == null ^ this.unsuccessful() == null) {
            return false;
        }
        if (other.unsuccessful() != null && !other.unsuccessful().equals(this.unsuccessful())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (successful() != null) {
            sb.append("Successful: ").append(successful()).append(",");
        }
        if (unsuccessful() != null) {
            sb.append("Unsuccessful: ").append(unsuccessful()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ModifyHostsResponse> {
        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully modified.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(Collection<String> successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that were successfully modified.
         * </p>
         * 
         * @param successful
         *        The IDs of the Dedicated Hosts that were successfully modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder successful(String... successful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
         * used.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful);

        /**
         * <p>
         * The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can be
         * used.
         * </p>
         * 
         * @param unsuccessful
         *        The IDs of the Dedicated Hosts that could not be modified. Check whether the setting you requested can
         *        be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder unsuccessful(UnsuccessfulItem... unsuccessful);
    }

    private static final class BuilderImpl implements Builder {
        private List<String> successful;

        private List<UnsuccessfulItem> unsuccessful;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyHostsResponse model) {
            setSuccessful(model.successful);
            setUnsuccessful(model.unsuccessful);
        }

        public final Collection<String> getSuccessful() {
            return successful;
        }

        @Override
        public final Builder successful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(String... successful) {
            successful(Arrays.asList(successful));
            return this;
        }

        public final void setSuccessful(Collection<String> successful) {
            this.successful = ResponseHostIdListCopier.copy(successful);
        }

        @SafeVarargs
        public final void setSuccessful(String... successful) {
            successful(Arrays.asList(successful));
        }

        public final Collection<UnsuccessfulItem> getUnsuccessful() {
            return unsuccessful;
        }

        @Override
        public final Builder unsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder unsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
            return this;
        }

        public final void setUnsuccessful(Collection<UnsuccessfulItem> unsuccessful) {
            this.unsuccessful = UnsuccessfulItemListCopier.copy(unsuccessful);
        }

        @SafeVarargs
        public final void setUnsuccessful(UnsuccessfulItem... unsuccessful) {
            unsuccessful(Arrays.asList(unsuccessful));
        }

        @Override
        public ModifyHostsResponse build() {
            return new ModifyHostsResponse(this);
        }
    }
}
