/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance to export.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceExportDetails implements ToCopyableBuilder<InstanceExportDetails.Builder, InstanceExportDetails> {
    private final String instanceId;

    private final String targetEnvironment;

    private InstanceExportDetails(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.targetEnvironment = builder.targetEnvironment;
    }

    /**
     * <p>
     * The ID of the resource being exported.
     * </p>
     * 
     * @return The ID of the resource being exported.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The target virtualization environment.
     * </p>
     * 
     * @return The target virtualization environment.
     * @see ExportEnvironment
     */
    public String targetEnvironment() {
        return targetEnvironment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((targetEnvironment() == null) ? 0 : targetEnvironment().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceExportDetails)) {
            return false;
        }
        InstanceExportDetails other = (InstanceExportDetails) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.targetEnvironment() == null ^ this.targetEnvironment() == null) {
            return false;
        }
        if (other.targetEnvironment() != null && !other.targetEnvironment().equals(this.targetEnvironment())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (targetEnvironment() != null) {
            sb.append("TargetEnvironment: ").append(targetEnvironment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceExportDetails> {
        /**
         * <p>
         * The ID of the resource being exported.
         * </p>
         * 
         * @param instanceId
         *        The ID of the resource being exported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(String targetEnvironment);

        /**
         * <p>
         * The target virtualization environment.
         * </p>
         * 
         * @param targetEnvironment
         *        The target virtualization environment.
         * @see ExportEnvironment
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExportEnvironment
         */
        Builder targetEnvironment(ExportEnvironment targetEnvironment);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String targetEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceExportDetails model) {
            setInstanceId(model.instanceId);
            setTargetEnvironment(model.targetEnvironment);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getTargetEnvironment() {
            return targetEnvironment;
        }

        @Override
        public final Builder targetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
            return this;
        }

        @Override
        public final Builder targetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
            return this;
        }

        public final void setTargetEnvironment(String targetEnvironment) {
            this.targetEnvironment = targetEnvironment;
        }

        public final void setTargetEnvironment(ExportEnvironment targetEnvironment) {
            this.targetEnvironment(targetEnvironment.toString());
        }

        @Override
        public InstanceExportDetails build() {
            return new InstanceExportDetails(this);
        }
    }
}
