/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the instance type that the Dedicated Host supports.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceCapacity implements ToCopyableBuilder<InstanceCapacity.Builder, InstanceCapacity> {
    private final Integer availableCapacity;

    private final String instanceType;

    private final Integer totalCapacity;

    private InstanceCapacity(BuilderImpl builder) {
        this.availableCapacity = builder.availableCapacity;
        this.instanceType = builder.instanceType;
        this.totalCapacity = builder.totalCapacity;
    }

    /**
     * <p>
     * The number of instances that can still be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The number of instances that can still be launched onto the Dedicated Host.
     */
    public Integer availableCapacity() {
        return availableCapacity;
    }

    /**
     * <p>
     * The instance type size supported by the Dedicated Host.
     * </p>
     * 
     * @return The instance type size supported by the Dedicated Host.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The total number of instances that can be launched onto the Dedicated Host.
     * </p>
     * 
     * @return The total number of instances that can be launched onto the Dedicated Host.
     */
    public Integer totalCapacity() {
        return totalCapacity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availableCapacity() == null) ? 0 : availableCapacity().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((totalCapacity() == null) ? 0 : totalCapacity().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceCapacity)) {
            return false;
        }
        InstanceCapacity other = (InstanceCapacity) obj;
        if (other.availableCapacity() == null ^ this.availableCapacity() == null) {
            return false;
        }
        if (other.availableCapacity() != null && !other.availableCapacity().equals(this.availableCapacity())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.totalCapacity() == null ^ this.totalCapacity() == null) {
            return false;
        }
        if (other.totalCapacity() != null && !other.totalCapacity().equals(this.totalCapacity())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availableCapacity() != null) {
            sb.append("AvailableCapacity: ").append(availableCapacity()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (totalCapacity() != null) {
            sb.append("TotalCapacity: ").append(totalCapacity()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceCapacity> {
        /**
         * <p>
         * The number of instances that can still be launched onto the Dedicated Host.
         * </p>
         * 
         * @param availableCapacity
         *        The number of instances that can still be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableCapacity(Integer availableCapacity);

        /**
         * <p>
         * The instance type size supported by the Dedicated Host.
         * </p>
         * 
         * @param instanceType
         *        The instance type size supported by the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The total number of instances that can be launched onto the Dedicated Host.
         * </p>
         * 
         * @param totalCapacity
         *        The total number of instances that can be launched onto the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalCapacity(Integer totalCapacity);
    }

    private static final class BuilderImpl implements Builder {
        private Integer availableCapacity;

        private String instanceType;

        private Integer totalCapacity;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceCapacity model) {
            setAvailableCapacity(model.availableCapacity);
            setInstanceType(model.instanceType);
            setTotalCapacity(model.totalCapacity);
        }

        public final Integer getAvailableCapacity() {
            return availableCapacity;
        }

        @Override
        public final Builder availableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
            return this;
        }

        public final void setAvailableCapacity(Integer availableCapacity) {
            this.availableCapacity = availableCapacity;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final Integer getTotalCapacity() {
            return totalCapacity;
        }

        @Override
        public final Builder totalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
            return this;
        }

        public final void setTotalCapacity(Integer totalCapacity) {
            this.totalCapacity = totalCapacity;
        }

        @Override
        public InstanceCapacity build() {
            return new InstanceCapacity(this);
        }
    }
}
