/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a block device mapping.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceBlockDeviceMapping implements
        ToCopyableBuilder<InstanceBlockDeviceMapping.Builder, InstanceBlockDeviceMapping> {
    private final String deviceName;

    private final EbsInstanceBlockDevice ebs;

    private InstanceBlockDeviceMapping(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.ebs = builder.ebs;
    }

    /**
     * <p>
     * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     * </p>
     * 
     * @return The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
     */
    public String deviceName() {
        return deviceName;
    }

    /**
     * <p>
     * Parameters used to automatically set up EBS volumes when the instance is launched.
     * </p>
     * 
     * @return Parameters used to automatically set up EBS volumes when the instance is launched.
     */
    public EbsInstanceBlockDevice ebs() {
        return ebs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((deviceName() == null) ? 0 : deviceName().hashCode());
        hashCode = 31 * hashCode + ((ebs() == null) ? 0 : ebs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceBlockDeviceMapping)) {
            return false;
        }
        InstanceBlockDeviceMapping other = (InstanceBlockDeviceMapping) obj;
        if (other.deviceName() == null ^ this.deviceName() == null) {
            return false;
        }
        if (other.deviceName() != null && !other.deviceName().equals(this.deviceName())) {
            return false;
        }
        if (other.ebs() == null ^ this.ebs() == null) {
            return false;
        }
        if (other.ebs() != null && !other.ebs().equals(this.ebs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (deviceName() != null) {
            sb.append("DeviceName: ").append(deviceName()).append(",");
        }
        if (ebs() != null) {
            sb.append("Ebs: ").append(ebs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceBlockDeviceMapping> {
        /**
         * <p>
         * The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * </p>
         * 
         * @param deviceName
         *        The device name exposed to the instance (for example, <code>/dev/sdh</code> or <code>xvdh</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deviceName(String deviceName);

        /**
         * <p>
         * Parameters used to automatically set up EBS volumes when the instance is launched.
         * </p>
         * 
         * @param ebs
         *        Parameters used to automatically set up EBS volumes when the instance is launched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebs(EbsInstanceBlockDevice ebs);
    }

    private static final class BuilderImpl implements Builder {
        private String deviceName;

        private EbsInstanceBlockDevice ebs;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceBlockDeviceMapping model) {
            setDeviceName(model.deviceName);
            setEbs(model.ebs);
        }

        public final String getDeviceName() {
            return deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final EbsInstanceBlockDevice getEbs() {
            return ebs;
        }

        @Override
        public final Builder ebs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
            return this;
        }

        public final void setEbs(EbsInstanceBlockDevice ebs) {
            this.ebs = ebs;
        }

        @Override
        public InstanceBlockDeviceMapping build() {
            return new InstanceBlockDeviceMapping(this);
        }
    }
}
