/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an instance attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class InstanceAttribute implements ToCopyableBuilder<InstanceAttribute.Builder, InstanceAttribute> {
    private final List<GroupIdentifier> groups;

    private final List<InstanceBlockDeviceMapping> blockDeviceMappings;

    private final Boolean disableApiTermination;

    private final Boolean enaSupport;

    private final Boolean ebsOptimized;

    private final String instanceId;

    private final String instanceInitiatedShutdownBehavior;

    private final String instanceType;

    private final String kernelId;

    private final List<ProductCode> productCodes;

    private final String ramdiskId;

    private final String rootDeviceName;

    private final Boolean sourceDestCheck;

    private final String sriovNetSupport;

    private final String userData;

    private InstanceAttribute(BuilderImpl builder) {
        this.groups = builder.groups;
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.disableApiTermination = builder.disableApiTermination;
        this.enaSupport = builder.enaSupport;
        this.ebsOptimized = builder.ebsOptimized;
        this.instanceId = builder.instanceId;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.kernelId = builder.kernelId;
        this.productCodes = builder.productCodes;
        this.ramdiskId = builder.ramdiskId;
        this.rootDeviceName = builder.rootDeviceName;
        this.sourceDestCheck = builder.sourceDestCheck;
        this.sriovNetSupport = builder.sriovNetSupport;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * The security groups associated with the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The security groups associated with the instance.
     */
    public List<GroupIdentifier> groups() {
        return groups;
    }

    /**
     * <p>
     * The block device mapping of the instance.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The block device mapping of the instance.
     */
    public List<InstanceBlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or API;
     * otherwise, you can.
     * </p>
     * 
     * @return If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI,
     *         or API; otherwise, you can.
     */
    public Boolean disableApiTermination() {
        return disableApiTermination;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with ENA is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with ENA is enabled.
     */
    public Boolean enaSupport() {
        return enaSupport;
    }

    /**
     * <p>
     * Indicates whether the instance is optimized for EBS I/O.
     * </p>
     * 
     * @return Indicates whether the instance is optimized for EBS I/O.
     */
    public Boolean ebsOptimized() {
        return ebsOptimized;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     */
    public String instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The instance type.
     * </p>
     * 
     * @return The instance type.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * A list of product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return A list of product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * The name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     * </p>
     * 
     * @return The name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
     */
    public String rootDeviceName() {
        return rootDeviceName;
    }

    /**
     * <p>
     * Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is enabled,
     * and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT instance to
     * perform NAT.
     * </p>
     * 
     * @return Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is
     *         enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a
     *         NAT instance to perform NAT.
     */
    public Boolean sourceDestCheck() {
        return sourceDestCheck;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    /**
     * <p>
     * The user data.
     * </p>
     * 
     * @return The user data.
     */
    public String userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((groups() == null) ? 0 : groups().hashCode());
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((disableApiTermination() == null) ? 0 : disableApiTermination().hashCode());
        hashCode = 31 * hashCode + ((enaSupport() == null) ? 0 : enaSupport().hashCode());
        hashCode = 31 * hashCode + ((ebsOptimized() == null) ? 0 : ebsOptimized().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode
                + ((instanceInitiatedShutdownBehavior() == null) ? 0 : instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((rootDeviceName() == null) ? 0 : rootDeviceName().hashCode());
        hashCode = 31 * hashCode + ((sourceDestCheck() == null) ? 0 : sourceDestCheck().hashCode());
        hashCode = 31 * hashCode + ((sriovNetSupport() == null) ? 0 : sriovNetSupport().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceAttribute)) {
            return false;
        }
        InstanceAttribute other = (InstanceAttribute) obj;
        if (other.groups() == null ^ this.groups() == null) {
            return false;
        }
        if (other.groups() != null && !other.groups().equals(this.groups())) {
            return false;
        }
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.disableApiTermination() == null ^ this.disableApiTermination() == null) {
            return false;
        }
        if (other.disableApiTermination() != null && !other.disableApiTermination().equals(this.disableApiTermination())) {
            return false;
        }
        if (other.enaSupport() == null ^ this.enaSupport() == null) {
            return false;
        }
        if (other.enaSupport() != null && !other.enaSupport().equals(this.enaSupport())) {
            return false;
        }
        if (other.ebsOptimized() == null ^ this.ebsOptimized() == null) {
            return false;
        }
        if (other.ebsOptimized() != null && !other.ebsOptimized().equals(this.ebsOptimized())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null
                && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.rootDeviceName() == null ^ this.rootDeviceName() == null) {
            return false;
        }
        if (other.rootDeviceName() != null && !other.rootDeviceName().equals(this.rootDeviceName())) {
            return false;
        }
        if (other.sourceDestCheck() == null ^ this.sourceDestCheck() == null) {
            return false;
        }
        if (other.sourceDestCheck() != null && !other.sourceDestCheck().equals(this.sourceDestCheck())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (groups() != null) {
            sb.append("Groups: ").append(groups()).append(",");
        }
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (disableApiTermination() != null) {
            sb.append("DisableApiTermination: ").append(disableApiTermination()).append(",");
        }
        if (enaSupport() != null) {
            sb.append("EnaSupport: ").append(enaSupport()).append(",");
        }
        if (ebsOptimized() != null) {
            sb.append("EbsOptimized: ").append(ebsOptimized()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(instanceInitiatedShutdownBehavior()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (rootDeviceName() != null) {
            sb.append("RootDeviceName: ").append(rootDeviceName()).append(",");
        }
        if (sourceDestCheck() != null) {
            sb.append("SourceDestCheck: ").append(sourceDestCheck()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, InstanceAttribute> {
        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(Collection<GroupIdentifier> groups);

        /**
         * <p>
         * The security groups associated with the instance.
         * </p>
         * 
         * @param groups
         *        The security groups associated with the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groups(GroupIdentifier... groups);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * The block device mapping of the instance.
         * </p>
         * 
         * @param blockDeviceMappings
         *        The block device mapping of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console, CLI, or
         * API; otherwise, you can.
         * </p>
         * 
         * @param disableApiTermination
         *        If the value is <code>true</code>, you can't terminate the instance through the Amazon EC2 console,
         *        CLI, or API; otherwise, you can.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disableApiTermination(Boolean disableApiTermination);

        /**
         * <p>
         * Indicates whether enhanced networking with ENA is enabled.
         * </p>
         * 
         * @param enaSupport
         *        Indicates whether enhanced networking with ENA is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enaSupport(Boolean enaSupport);

        /**
         * <p>
         * Indicates whether the instance is optimized for EBS I/O.
         * </p>
         * 
         * @param ebsOptimized
         *        Indicates whether the instance is optimized for EBS I/O.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ebsOptimized(Boolean ebsOptimized);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The instance type.
         * </p>
         * 
         * @param instanceType
         *        The instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * A list of product codes.
         * </p>
         * 
         * @param productCodes
         *        A list of product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * The name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * </p>
         * 
         * @param rootDeviceName
         *        The name of the root device (for example, <code>/dev/sda1</code> or <code>/dev/xvda</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootDeviceName(String rootDeviceName);

        /**
         * <p>
         * Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking is
         * enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code> for a NAT
         * instance to perform NAT.
         * </p>
         * 
         * @param sourceDestCheck
         *        Indicates whether source/destination checking is enabled. A value of <code>true</code> means checking
         *        is enabled, and <code>false</code> means checking is disabled. This value must be <code>false</code>
         *        for a NAT instance to perform NAT.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceDestCheck(Boolean sourceDestCheck);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);

        /**
         * <p>
         * The user data.
         * </p>
         * 
         * @param userData
         *        The user data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(String userData);
    }

    private static final class BuilderImpl implements Builder {
        private List<GroupIdentifier> groups;

        private List<InstanceBlockDeviceMapping> blockDeviceMappings;

        private Boolean disableApiTermination;

        private Boolean enaSupport;

        private Boolean ebsOptimized;

        private String instanceId;

        private String instanceInitiatedShutdownBehavior;

        private String instanceType;

        private String kernelId;

        private List<ProductCode> productCodes;

        private String ramdiskId;

        private String rootDeviceName;

        private Boolean sourceDestCheck;

        private String sriovNetSupport;

        private String userData;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceAttribute model) {
            setGroups(model.groups);
            setBlockDeviceMappings(model.blockDeviceMappings);
            setDisableApiTermination(model.disableApiTermination);
            setEnaSupport(model.enaSupport);
            setEbsOptimized(model.ebsOptimized);
            setInstanceId(model.instanceId);
            setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            setInstanceType(model.instanceType);
            setKernelId(model.kernelId);
            setProductCodes(model.productCodes);
            setRamdiskId(model.ramdiskId);
            setRootDeviceName(model.rootDeviceName);
            setSourceDestCheck(model.sourceDestCheck);
            setSriovNetSupport(model.sriovNetSupport);
            setUserData(model.userData);
        }

        public final Collection<GroupIdentifier> getGroups() {
            return groups;
        }

        @Override
        public final Builder groups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
            return this;
        }

        public final void setGroups(Collection<GroupIdentifier> groups) {
            this.groups = GroupIdentifierListCopier.copy(groups);
        }

        @SafeVarargs
        public final void setGroups(GroupIdentifier... groups) {
            groups(Arrays.asList(groups));
        }

        public final Collection<InstanceBlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<InstanceBlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = InstanceBlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(InstanceBlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final Boolean getDisableApiTermination() {
            return disableApiTermination;
        }

        @Override
        public final Builder disableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        public final void setDisableApiTermination(Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
        }

        public final Boolean getEnaSupport() {
            return enaSupport;
        }

        @Override
        public final Builder enaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
            return this;
        }

        public final void setEnaSupport(Boolean enaSupport) {
            this.enaSupport = enaSupport;
        }

        public final Boolean getEbsOptimized() {
            return ebsOptimized;
        }

        @Override
        public final Builder ebsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        public final void setEbsOptimized(Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getRootDeviceName() {
            return rootDeviceName;
        }

        @Override
        public final Builder rootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
            return this;
        }

        public final void setRootDeviceName(String rootDeviceName) {
            this.rootDeviceName = rootDeviceName;
        }

        public final Boolean getSourceDestCheck() {
            return sourceDestCheck;
        }

        @Override
        public final Builder sourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        public final void setSourceDestCheck(Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        public final String getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(String userData) {
            this.userData = userData;
        }

        @Override
        public InstanceAttribute build() {
            return new InstanceAttribute(this);
        }
    }
}
