/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an import instance task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportInstanceTaskDetails implements ToCopyableBuilder<ImportInstanceTaskDetails.Builder, ImportInstanceTaskDetails> {
    private final String description;

    private final String instanceId;

    private final String platform;

    private final List<ImportInstanceVolumeDetailItem> volumes;

    private ImportInstanceTaskDetails(BuilderImpl builder) {
        this.description = builder.description;
        this.instanceId = builder.instanceId;
        this.platform = builder.platform;
        this.volumes = builder.volumes;
    }

    /**
     * <p>
     * A description of the task.
     * </p>
     * 
     * @return A description of the task.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The instance operating system.
     * </p>
     * 
     * @return The instance operating system.
     * @see PlatformValues
     */
    public String platform() {
        return platform;
    }

    /**
     * <p>
     * One or more volumes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more volumes.
     */
    public List<ImportInstanceVolumeDetailItem> volumes() {
        return volumes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((platform() == null) ? 0 : platform().hashCode());
        hashCode = 31 * hashCode + ((volumes() == null) ? 0 : volumes().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.platform() == null ^ this.platform() == null) {
            return false;
        }
        if (other.platform() != null && !other.platform().equals(this.platform())) {
            return false;
        }
        if (other.volumes() == null ^ this.volumes() == null) {
            return false;
        }
        if (other.volumes() != null && !other.volumes().equals(this.volumes())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (platform() != null) {
            sb.append("Platform: ").append(platform()).append(",");
        }
        if (volumes() != null) {
            sb.append("Volumes: ").append(volumes()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportInstanceTaskDetails> {
        /**
         * <p>
         * A description of the task.
         * </p>
         * 
         * @param description
         *        A description of the task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(String platform);

        /**
         * <p>
         * The instance operating system.
         * </p>
         * 
         * @param platform
         *        The instance operating system.
         * @see PlatformValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformValues
         */
        Builder platform(PlatformValues platform);

        /**
         * <p>
         * One or more volumes.
         * </p>
         * 
         * @param volumes
         *        One or more volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes);

        /**
         * <p>
         * One or more volumes.
         * </p>
         * 
         * @param volumes
         *        One or more volumes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder volumes(ImportInstanceVolumeDetailItem... volumes);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String instanceId;

        private String platform;

        private List<ImportInstanceVolumeDetailItem> volumes;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceTaskDetails model) {
            setDescription(model.description);
            setInstanceId(model.instanceId);
            setPlatform(model.platform);
            setVolumes(model.volumes);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getPlatform() {
            return platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformValues platform) {
            this.platform(platform.toString());
            return this;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        public final void setPlatform(PlatformValues platform) {
            this.platform(platform.toString());
        }

        public final Collection<ImportInstanceVolumeDetailItem> getVolumes() {
            return volumes;
        }

        @Override
        public final Builder volumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumes(ImportInstanceVolumeDetailItem... volumes) {
            volumes(Arrays.asList(volumes));
            return this;
        }

        public final void setVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
            this.volumes = ImportInstanceVolumeDetailSetCopier.copy(volumes);
        }

        @SafeVarargs
        public final void setVolumes(ImportInstanceVolumeDetailItem... volumes) {
            volumes(Arrays.asList(volumes));
        }

        @Override
        public ImportInstanceTaskDetails build() {
            return new ImportInstanceTaskDetails(this);
        }
    }
}
