/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the launch specification for VM import.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImportInstanceLaunchSpecification implements
        ToCopyableBuilder<ImportInstanceLaunchSpecification.Builder, ImportInstanceLaunchSpecification> {
    private final String additionalInfo;

    private final String architecture;

    private final List<String> groupIds;

    private final List<String> groupNames;

    private final String instanceInitiatedShutdownBehavior;

    private final String instanceType;

    private final Boolean monitoring;

    private final Placement placement;

    private final String privateIpAddress;

    private final String subnetId;

    private final UserData userData;

    private ImportInstanceLaunchSpecification(BuilderImpl builder) {
        this.additionalInfo = builder.additionalInfo;
        this.architecture = builder.architecture;
        this.groupIds = builder.groupIds;
        this.groupNames = builder.groupNames;
        this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
        this.instanceType = builder.instanceType;
        this.monitoring = builder.monitoring;
        this.placement = builder.placement;
        this.privateIpAddress = builder.privateIpAddress;
        this.subnetId = builder.subnetId;
        this.userData = builder.userData;
    }

    /**
     * <p>
     * Reserved.
     * </p>
     * 
     * @return Reserved.
     */
    public String additionalInfo() {
        return additionalInfo;
    }

    /**
     * <p>
     * The architecture of the instance.
     * </p>
     * 
     * @return The architecture of the instance.
     * @see ArchitectureValues
     */
    public String architecture() {
        return architecture;
    }

    /**
     * <p>
     * One or more security group IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group IDs.
     */
    public List<String> groupIds() {
        return groupIds;
    }

    /**
     * <p>
     * One or more security group names.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more security group names.
     */
    public List<String> groupNames() {
        return groupNames;
    }

    /**
     * <p>
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     * operating system command for system shutdown).
     * </p>
     * 
     * @return Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
     *         operating system command for system shutdown).
     * @see ShutdownBehavior
     */
    public String instanceInitiatedShutdownBehavior() {
        return instanceInitiatedShutdownBehavior;
    }

    /**
     * <p>
     * The instance type. For more information about the instance types that you can import, see <a
     * href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     * >Instance Types</a> in the VM Import/Export User Guide.
     * </p>
     * 
     * @return The instance type. For more information about the instance types that you can import, see <a
     *         href="http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
     *         >Instance Types</a> in the VM Import/Export User Guide.
     * @see InstanceType
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates whether monitoring is enabled.
     * </p>
     * 
     * @return Indicates whether monitoring is enabled.
     */
    public Boolean monitoring() {
        return monitoring;
    }

    /**
     * <p>
     * The placement information for the instance.
     * </p>
     * 
     * @return The placement information for the instance.
     */
    public Placement placement() {
        return placement;
    }

    /**
     * <p>
     * [EC2-VPC] An available IP address from the IP address range of the subnet.
     * </p>
     * 
     * @return [EC2-VPC] An available IP address from the IP address range of the subnet.
     */
    public String privateIpAddress() {
        return privateIpAddress;
    }

    /**
     * <p>
     * [EC2-VPC] The ID of the subnet in which to launch the instance.
     * </p>
     * 
     * @return [EC2-VPC] The ID of the subnet in which to launch the instance.
     */
    public String subnetId() {
        return subnetId;
    }

    /**
     * <p>
     * The user data to make available to the instance. If you are using an AWS SDK or command line tool,
     * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     * Base64-encoded text.
     * </p>
     * 
     * @return The user data to make available to the instance. If you are using an AWS SDK or command line tool,
     *         Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
     *         Base64-encoded text.
     */
    public UserData userData() {
        return userData;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((additionalInfo() == null) ? 0 : additionalInfo().hashCode());
        hashCode = 31 * hashCode + ((architecture() == null) ? 0 : architecture().hashCode());
        hashCode = 31 * hashCode + ((groupIds() == null) ? 0 : groupIds().hashCode());
        hashCode = 31 * hashCode + ((groupNames() == null) ? 0 : groupNames().hashCode());
        hashCode = 31 * hashCode
                + ((instanceInitiatedShutdownBehavior() == null) ? 0 : instanceInitiatedShutdownBehavior().hashCode());
        hashCode = 31 * hashCode + ((instanceType() == null) ? 0 : instanceType().hashCode());
        hashCode = 31 * hashCode + ((monitoring() == null) ? 0 : monitoring().hashCode());
        hashCode = 31 * hashCode + ((placement() == null) ? 0 : placement().hashCode());
        hashCode = 31 * hashCode + ((privateIpAddress() == null) ? 0 : privateIpAddress().hashCode());
        hashCode = 31 * hashCode + ((subnetId() == null) ? 0 : subnetId().hashCode());
        hashCode = 31 * hashCode + ((userData() == null) ? 0 : userData().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceLaunchSpecification)) {
            return false;
        }
        ImportInstanceLaunchSpecification other = (ImportInstanceLaunchSpecification) obj;
        if (other.additionalInfo() == null ^ this.additionalInfo() == null) {
            return false;
        }
        if (other.additionalInfo() != null && !other.additionalInfo().equals(this.additionalInfo())) {
            return false;
        }
        if (other.architecture() == null ^ this.architecture() == null) {
            return false;
        }
        if (other.architecture() != null && !other.architecture().equals(this.architecture())) {
            return false;
        }
        if (other.groupIds() == null ^ this.groupIds() == null) {
            return false;
        }
        if (other.groupIds() != null && !other.groupIds().equals(this.groupIds())) {
            return false;
        }
        if (other.groupNames() == null ^ this.groupNames() == null) {
            return false;
        }
        if (other.groupNames() != null && !other.groupNames().equals(this.groupNames())) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() == null ^ this.instanceInitiatedShutdownBehavior() == null) {
            return false;
        }
        if (other.instanceInitiatedShutdownBehavior() != null
                && !other.instanceInitiatedShutdownBehavior().equals(this.instanceInitiatedShutdownBehavior())) {
            return false;
        }
        if (other.instanceType() == null ^ this.instanceType() == null) {
            return false;
        }
        if (other.instanceType() != null && !other.instanceType().equals(this.instanceType())) {
            return false;
        }
        if (other.monitoring() == null ^ this.monitoring() == null) {
            return false;
        }
        if (other.monitoring() != null && !other.monitoring().equals(this.monitoring())) {
            return false;
        }
        if (other.placement() == null ^ this.placement() == null) {
            return false;
        }
        if (other.placement() != null && !other.placement().equals(this.placement())) {
            return false;
        }
        if (other.privateIpAddress() == null ^ this.privateIpAddress() == null) {
            return false;
        }
        if (other.privateIpAddress() != null && !other.privateIpAddress().equals(this.privateIpAddress())) {
            return false;
        }
        if (other.subnetId() == null ^ this.subnetId() == null) {
            return false;
        }
        if (other.subnetId() != null && !other.subnetId().equals(this.subnetId())) {
            return false;
        }
        if (other.userData() == null ^ this.userData() == null) {
            return false;
        }
        if (other.userData() != null && !other.userData().equals(this.userData())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (additionalInfo() != null) {
            sb.append("AdditionalInfo: ").append(additionalInfo()).append(",");
        }
        if (architecture() != null) {
            sb.append("Architecture: ").append(architecture()).append(",");
        }
        if (groupIds() != null) {
            sb.append("GroupIds: ").append(groupIds()).append(",");
        }
        if (groupNames() != null) {
            sb.append("GroupNames: ").append(groupNames()).append(",");
        }
        if (instanceInitiatedShutdownBehavior() != null) {
            sb.append("InstanceInitiatedShutdownBehavior: ").append(instanceInitiatedShutdownBehavior()).append(",");
        }
        if (instanceType() != null) {
            sb.append("InstanceType: ").append(instanceType()).append(",");
        }
        if (monitoring() != null) {
            sb.append("Monitoring: ").append(monitoring()).append(",");
        }
        if (placement() != null) {
            sb.append("Placement: ").append(placement()).append(",");
        }
        if (privateIpAddress() != null) {
            sb.append("PrivateIpAddress: ").append(privateIpAddress()).append(",");
        }
        if (subnetId() != null) {
            sb.append("SubnetId: ").append(subnetId()).append(",");
        }
        if (userData() != null) {
            sb.append("UserData: ").append(userData()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImportInstanceLaunchSpecification> {
        /**
         * <p>
         * Reserved.
         * </p>
         * 
         * @param additionalInfo
         *        Reserved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalInfo(String additionalInfo);

        /**
         * <p>
         * The architecture of the instance.
         * </p>
         * 
         * @param architecture
         *        The architecture of the instance.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(String architecture);

        /**
         * <p>
         * The architecture of the instance.
         * </p>
         * 
         * @param architecture
         *        The architecture of the instance.
         * @see ArchitectureValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ArchitectureValues
         */
        Builder architecture(ArchitectureValues architecture);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(Collection<String> groupIds);

        /**
         * <p>
         * One or more security group IDs.
         * </p>
         * 
         * @param groupIds
         *        One or more security group IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupIds(String... groupIds);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(Collection<String> groupNames);

        /**
         * <p>
         * One or more security group names.
         * </p>
         * 
         * @param groupNames
         *        One or more security group names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupNames(String... groupNames);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the
         * operating system command for system shutdown).
         * </p>
         * 
         * @param instanceInitiatedShutdownBehavior
         *        Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using
         *        the operating system command for system shutdown).
         * @see ShutdownBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShutdownBehavior
         */
        Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior);

        /**
         * <p>
         * The instance type. For more information about the instance types that you can import, see <a href=
         * "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         * >Instance Types</a> in the VM Import/Export User Guide.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information about the instance types that you can import, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         *        >Instance Types</a> in the VM Import/Export User Guide.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type. For more information about the instance types that you can import, see <a href=
         * "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         * >Instance Types</a> in the VM Import/Export User Guide.
         * </p>
         * 
         * @param instanceType
         *        The instance type. For more information about the instance types that you can import, see <a href=
         *        "http://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#vmimport-instance-types"
         *        >Instance Types</a> in the VM Import/Export User Guide.
         * @see InstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InstanceType
         */
        Builder instanceType(InstanceType instanceType);

        /**
         * <p>
         * Indicates whether monitoring is enabled.
         * </p>
         * 
         * @param monitoring
         *        Indicates whether monitoring is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitoring(Boolean monitoring);

        /**
         * <p>
         * The placement information for the instance.
         * </p>
         * 
         * @param placement
         *        The placement information for the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placement(Placement placement);

        /**
         * <p>
         * [EC2-VPC] An available IP address from the IP address range of the subnet.
         * </p>
         * 
         * @param privateIpAddress
         *        [EC2-VPC] An available IP address from the IP address range of the subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder privateIpAddress(String privateIpAddress);

        /**
         * <p>
         * [EC2-VPC] The ID of the subnet in which to launch the instance.
         * </p>
         * 
         * @param subnetId
         *        [EC2-VPC] The ID of the subnet in which to launch the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subnetId(String subnetId);

        /**
         * <p>
         * The user data to make available to the instance. If you are using an AWS SDK or command line tool,
         * Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must provide
         * Base64-encoded text.
         * </p>
         * 
         * @param userData
         *        The user data to make available to the instance. If you are using an AWS SDK or command line tool,
         *        Base64-encoding is performed for you, and you can load the text from a file. Otherwise, you must
         *        provide Base64-encoded text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userData(UserData userData);
    }

    private static final class BuilderImpl implements Builder {
        private String additionalInfo;

        private String architecture;

        private List<String> groupIds;

        private List<String> groupNames;

        private String instanceInitiatedShutdownBehavior;

        private String instanceType;

        private Boolean monitoring;

        private Placement placement;

        private String privateIpAddress;

        private String subnetId;

        private UserData userData;

        private BuilderImpl() {
        }

        private BuilderImpl(ImportInstanceLaunchSpecification model) {
            setAdditionalInfo(model.additionalInfo);
            setArchitecture(model.architecture);
            setGroupIds(model.groupIds);
            setGroupNames(model.groupNames);
            setInstanceInitiatedShutdownBehavior(model.instanceInitiatedShutdownBehavior);
            setInstanceType(model.instanceType);
            setMonitoring(model.monitoring);
            setPlacement(model.placement);
            setPrivateIpAddress(model.privateIpAddress);
            setSubnetId(model.subnetId);
            setUserData(model.userData);
        }

        public final String getAdditionalInfo() {
            return additionalInfo;
        }

        @Override
        public final Builder additionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
            return this;
        }

        public final void setAdditionalInfo(String additionalInfo) {
            this.additionalInfo = additionalInfo;
        }

        public final String getArchitecture() {
            return architecture;
        }

        @Override
        public final Builder architecture(String architecture) {
            this.architecture = architecture;
            return this;
        }

        @Override
        public final Builder architecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
            return this;
        }

        public final void setArchitecture(String architecture) {
            this.architecture = architecture;
        }

        public final void setArchitecture(ArchitectureValues architecture) {
            this.architecture(architecture.toString());
        }

        public final Collection<String> getGroupIds() {
            return groupIds;
        }

        @Override
        public final Builder groupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
            return this;
        }

        public final void setGroupIds(Collection<String> groupIds) {
            this.groupIds = SecurityGroupIdStringListCopier.copy(groupIds);
        }

        @SafeVarargs
        public final void setGroupIds(String... groupIds) {
            groupIds(Arrays.asList(groupIds));
        }

        public final Collection<String> getGroupNames() {
            return groupNames;
        }

        @Override
        public final Builder groupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
            return this;
        }

        public final void setGroupNames(Collection<String> groupNames) {
            this.groupNames = SecurityGroupStringListCopier.copy(groupNames);
        }

        @SafeVarargs
        public final void setGroupNames(String... groupNames) {
            groupNames(Arrays.asList(groupNames));
        }

        public final String getInstanceInitiatedShutdownBehavior() {
            return instanceInitiatedShutdownBehavior;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        @Override
        public final Builder instanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
            return this;
        }

        public final void setInstanceInitiatedShutdownBehavior(String instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
        }

        public final void setInstanceInitiatedShutdownBehavior(ShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior(instanceInitiatedShutdownBehavior.toString());
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final void setInstanceType(InstanceType instanceType) {
            this.instanceType(instanceType.toString());
        }

        public final Boolean getMonitoring() {
            return monitoring;
        }

        @Override
        public final Builder monitoring(Boolean monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public final void setMonitoring(Boolean monitoring) {
            this.monitoring = monitoring;
        }

        public final Placement getPlacement() {
            return placement;
        }

        @Override
        public final Builder placement(Placement placement) {
            this.placement = placement;
            return this;
        }

        public final void setPlacement(Placement placement) {
            this.placement = placement;
        }

        public final String getPrivateIpAddress() {
            return privateIpAddress;
        }

        @Override
        public final Builder privateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        public final void setPrivateIpAddress(String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
        }

        public final String getSubnetId() {
            return subnetId;
        }

        @Override
        public final Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this;
        }

        public final void setSubnetId(String subnetId) {
            this.subnetId = subnetId;
        }

        public final UserData getUserData() {
            return userData;
        }

        @Override
        public final Builder userData(UserData userData) {
            this.userData = userData;
            return this;
        }

        public final void setUserData(UserData userData) {
            this.userData = userData;
        }

        @Override
        public ImportInstanceLaunchSpecification build() {
            return new ImportInstanceLaunchSpecification(this);
        }
    }
}
