/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an image attribute.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ImageAttribute implements ToCopyableBuilder<ImageAttribute.Builder, ImageAttribute> {
    private final List<BlockDeviceMapping> blockDeviceMappings;

    private final String imageId;

    private final List<LaunchPermission> launchPermissions;

    private final List<ProductCode> productCodes;

    private final String description;

    private final String kernelId;

    private final String ramdiskId;

    private final String sriovNetSupport;

    private ImageAttribute(BuilderImpl builder) {
        this.blockDeviceMappings = builder.blockDeviceMappings;
        this.imageId = builder.imageId;
        this.launchPermissions = builder.launchPermissions;
        this.productCodes = builder.productCodes;
        this.description = builder.description;
        this.kernelId = builder.kernelId;
        this.ramdiskId = builder.ramdiskId;
        this.sriovNetSupport = builder.sriovNetSupport;
    }

    /**
     * <p>
     * One or more block device mapping entries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more block device mapping entries.
     */
    public List<BlockDeviceMapping> blockDeviceMappings() {
        return blockDeviceMappings;
    }

    /**
     * <p>
     * The ID of the AMI.
     * </p>
     * 
     * @return The ID of the AMI.
     */
    public String imageId() {
        return imageId;
    }

    /**
     * <p>
     * One or more launch permissions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more launch permissions.
     */
    public List<LaunchPermission> launchPermissions() {
        return launchPermissions;
    }

    /**
     * <p>
     * One or more product codes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more product codes.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * A description for the AMI.
     * </p>
     * 
     * @return A description for the AMI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The kernel ID.
     * </p>
     * 
     * @return The kernel ID.
     */
    public String kernelId() {
        return kernelId;
    }

    /**
     * <p>
     * The RAM disk ID.
     * </p>
     * 
     * @return The RAM disk ID.
     */
    public String ramdiskId() {
        return ramdiskId;
    }

    /**
     * <p>
     * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     * </p>
     * 
     * @return Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
     */
    public String sriovNetSupport() {
        return sriovNetSupport;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((blockDeviceMappings() == null) ? 0 : blockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + ((imageId() == null) ? 0 : imageId().hashCode());
        hashCode = 31 * hashCode + ((launchPermissions() == null) ? 0 : launchPermissions().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((kernelId() == null) ? 0 : kernelId().hashCode());
        hashCode = 31 * hashCode + ((ramdiskId() == null) ? 0 : ramdiskId().hashCode());
        hashCode = 31 * hashCode + ((sriovNetSupport() == null) ? 0 : sriovNetSupport().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageAttribute)) {
            return false;
        }
        ImageAttribute other = (ImageAttribute) obj;
        if (other.blockDeviceMappings() == null ^ this.blockDeviceMappings() == null) {
            return false;
        }
        if (other.blockDeviceMappings() != null && !other.blockDeviceMappings().equals(this.blockDeviceMappings())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.launchPermissions() == null ^ this.launchPermissions() == null) {
            return false;
        }
        if (other.launchPermissions() != null && !other.launchPermissions().equals(this.launchPermissions())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.kernelId() == null ^ this.kernelId() == null) {
            return false;
        }
        if (other.kernelId() != null && !other.kernelId().equals(this.kernelId())) {
            return false;
        }
        if (other.ramdiskId() == null ^ this.ramdiskId() == null) {
            return false;
        }
        if (other.ramdiskId() != null && !other.ramdiskId().equals(this.ramdiskId())) {
            return false;
        }
        if (other.sriovNetSupport() == null ^ this.sriovNetSupport() == null) {
            return false;
        }
        if (other.sriovNetSupport() != null && !other.sriovNetSupport().equals(this.sriovNetSupport())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (blockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: ").append(blockDeviceMappings()).append(",");
        }
        if (imageId() != null) {
            sb.append("ImageId: ").append(imageId()).append(",");
        }
        if (launchPermissions() != null) {
            sb.append("LaunchPermissions: ").append(launchPermissions()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (kernelId() != null) {
            sb.append("KernelId: ").append(kernelId()).append(",");
        }
        if (ramdiskId() != null) {
            sb.append("RamdiskId: ").append(ramdiskId()).append(",");
        }
        if (sriovNetSupport() != null) {
            sb.append("SriovNetSupport: ").append(sriovNetSupport()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ImageAttribute> {
        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings);

        /**
         * <p>
         * One or more block device mapping entries.
         * </p>
         * 
         * @param blockDeviceMappings
         *        One or more block device mapping entries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings);

        /**
         * <p>
         * The ID of the AMI.
         * </p>
         * 
         * @param imageId
         *        The ID of the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(String imageId);

        /**
         * <p>
         * One or more launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        One or more launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(Collection<LaunchPermission> launchPermissions);

        /**
         * <p>
         * One or more launch permissions.
         * </p>
         * 
         * @param launchPermissions
         *        One or more launch permissions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPermissions(LaunchPermission... launchPermissions);

        /**
         * <p>
         * One or more product codes.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * One or more product codes.
         * </p>
         * 
         * @param productCodes
         *        One or more product codes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * A description for the AMI.
         * </p>
         * 
         * @param description
         *        A description for the AMI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The kernel ID.
         * </p>
         * 
         * @param kernelId
         *        The kernel ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kernelId(String kernelId);

        /**
         * <p>
         * The RAM disk ID.
         * </p>
         * 
         * @param ramdiskId
         *        The RAM disk ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ramdiskId(String ramdiskId);

        /**
         * <p>
         * Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * </p>
         * 
         * @param sriovNetSupport
         *        Indicates whether enhanced networking with the Intel 82599 Virtual Function interface is enabled.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sriovNetSupport(String sriovNetSupport);
    }

    private static final class BuilderImpl implements Builder {
        private List<BlockDeviceMapping> blockDeviceMappings;

        private String imageId;

        private List<LaunchPermission> launchPermissions;

        private List<ProductCode> productCodes;

        private String description;

        private String kernelId;

        private String ramdiskId;

        private String sriovNetSupport;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageAttribute model) {
            setBlockDeviceMappings(model.blockDeviceMappings);
            setImageId(model.imageId);
            setLaunchPermissions(model.launchPermissions);
            setProductCodes(model.productCodes);
            setDescription(model.description);
            setKernelId(model.kernelId);
            setRamdiskId(model.ramdiskId);
            setSriovNetSupport(model.sriovNetSupport);
        }

        public final Collection<BlockDeviceMapping> getBlockDeviceMappings() {
            return blockDeviceMappings;
        }

        @Override
        public final Builder blockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
            return this;
        }

        public final void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
            this.blockDeviceMappings = BlockDeviceMappingListCopier.copy(blockDeviceMappings);
        }

        @SafeVarargs
        public final void setBlockDeviceMappings(BlockDeviceMapping... blockDeviceMappings) {
            blockDeviceMappings(Arrays.asList(blockDeviceMappings));
        }

        public final String getImageId() {
            return imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<LaunchPermission> getLaunchPermissions() {
            return launchPermissions;
        }

        @Override
        public final Builder launchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder launchPermissions(LaunchPermission... launchPermissions) {
            launchPermissions(Arrays.asList(launchPermissions));
            return this;
        }

        public final void setLaunchPermissions(Collection<LaunchPermission> launchPermissions) {
            this.launchPermissions = LaunchPermissionListCopier.copy(launchPermissions);
        }

        @SafeVarargs
        public final void setLaunchPermissions(LaunchPermission... launchPermissions) {
            launchPermissions(Arrays.asList(launchPermissions));
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getKernelId() {
            return kernelId;
        }

        @Override
        public final Builder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public final void setKernelId(String kernelId) {
            this.kernelId = kernelId;
        }

        public final String getRamdiskId() {
            return ramdiskId;
        }

        @Override
        public final Builder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public final void setRamdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
        }

        public final String getSriovNetSupport() {
            return sriovNetSupport;
        }

        @Override
        public final Builder sriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
            return this;
        }

        public final void setSriovNetSupport(String sriovNetSupport) {
            this.sriovNetSupport = sriovNetSupport;
        }

        @Override
        public ImageAttribute build() {
            return new ImageAttribute(this);
        }
    }
}
