/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of GetConsoleOutput.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class GetConsoleOutputResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<GetConsoleOutputResponse.Builder, GetConsoleOutputResponse> {
    private final String instanceId;

    private final String output;

    private final Instant timestamp;

    private GetConsoleOutputResponse(BuilderImpl builder) {
        this.instanceId = builder.instanceId;
        this.output = builder.output;
        this.timestamp = builder.timestamp;
    }

    /**
     * <p>
     * The ID of the instance.
     * </p>
     * 
     * @return The ID of the instance.
     */
    public String instanceId() {
        return instanceId;
    }

    /**
     * <p>
     * The console output, Base64-encoded. If using a command line tool, the tool decodes the output for you.
     * </p>
     * 
     * @return The console output, Base64-encoded. If using a command line tool, the tool decodes the output for you.
     */
    public String output() {
        return output;
    }

    /**
     * <p>
     * The time the output was last updated.
     * </p>
     * 
     * @return The time the output was last updated.
     */
    public Instant timestamp() {
        return timestamp;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((instanceId() == null) ? 0 : instanceId().hashCode());
        hashCode = 31 * hashCode + ((output() == null) ? 0 : output().hashCode());
        hashCode = 31 * hashCode + ((timestamp() == null) ? 0 : timestamp().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetConsoleOutputResponse)) {
            return false;
        }
        GetConsoleOutputResponse other = (GetConsoleOutputResponse) obj;
        if (other.instanceId() == null ^ this.instanceId() == null) {
            return false;
        }
        if (other.instanceId() != null && !other.instanceId().equals(this.instanceId())) {
            return false;
        }
        if (other.output() == null ^ this.output() == null) {
            return false;
        }
        if (other.output() != null && !other.output().equals(this.output())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (instanceId() != null) {
            sb.append("InstanceId: ").append(instanceId()).append(",");
        }
        if (output() != null) {
            sb.append("Output: ").append(output()).append(",");
        }
        if (timestamp() != null) {
            sb.append("Timestamp: ").append(timestamp()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, GetConsoleOutputResponse> {
        /**
         * <p>
         * The ID of the instance.
         * </p>
         * 
         * @param instanceId
         *        The ID of the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceId(String instanceId);

        /**
         * <p>
         * The console output, Base64-encoded. If using a command line tool, the tool decodes the output for you.
         * </p>
         * 
         * @param output
         *        The console output, Base64-encoded. If using a command line tool, the tool decodes the output for you.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder output(String output);

        /**
         * <p>
         * The time the output was last updated.
         * </p>
         * 
         * @param timestamp
         *        The time the output was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);
    }

    private static final class BuilderImpl implements Builder {
        private String instanceId;

        private String output;

        private Instant timestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetConsoleOutputResponse model) {
            setInstanceId(model.instanceId);
            setOutput(model.output);
            setTimestamp(model.timestamp);
        }

        public final String getInstanceId() {
            return instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        public final String getOutput() {
            return output;
        }

        @Override
        public final Builder output(String output) {
            this.output = output;
            return this;
        }

        public final void setOutput(String output) {
            this.output = output;
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public GetConsoleOutputResponse build() {
            return new GetConsoleOutputResponse(this);
        }
    }
}
