/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Amazon FPGA image (AFI).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class FpgaImage implements ToCopyableBuilder<FpgaImage.Builder, FpgaImage> {
    private final String fpgaImageId;

    private final String fpgaImageGlobalId;

    private final String name;

    private final String description;

    private final String shellVersion;

    private final PciId pciId;

    private final FpgaImageState state;

    private final Instant createTime;

    private final Instant updateTime;

    private final String ownerId;

    private final String ownerAlias;

    private final List<ProductCode> productCodes;

    private final List<Tag> tags;

    private FpgaImage(BuilderImpl builder) {
        this.fpgaImageId = builder.fpgaImageId;
        this.fpgaImageGlobalId = builder.fpgaImageGlobalId;
        this.name = builder.name;
        this.description = builder.description;
        this.shellVersion = builder.shellVersion;
        this.pciId = builder.pciId;
        this.state = builder.state;
        this.createTime = builder.createTime;
        this.updateTime = builder.updateTime;
        this.ownerId = builder.ownerId;
        this.ownerAlias = builder.ownerAlias;
        this.productCodes = builder.productCodes;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The FPGA image identifier (AFI ID).
     * </p>
     * 
     * @return The FPGA image identifier (AFI ID).
     */
    public String fpgaImageId() {
        return fpgaImageId;
    }

    /**
     * <p>
     * The global FPGA image identifier (AGFI ID).
     * </p>
     * 
     * @return The global FPGA image identifier (AGFI ID).
     */
    public String fpgaImageGlobalId() {
        return fpgaImageGlobalId;
    }

    /**
     * <p>
     * The name of the AFI.
     * </p>
     * 
     * @return The name of the AFI.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The description of the AFI.
     * </p>
     * 
     * @return The description of the AFI.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The version of the AWS Shell that was used to create the bitstream.
     * </p>
     * 
     * @return The version of the AWS Shell that was used to create the bitstream.
     */
    public String shellVersion() {
        return shellVersion;
    }

    /**
     * <p>
     * Information about the PCI bus.
     * </p>
     * 
     * @return Information about the PCI bus.
     */
    public PciId pciId() {
        return pciId;
    }

    /**
     * <p>
     * Information about the state of the AFI.
     * </p>
     * 
     * @return Information about the state of the AFI.
     */
    public FpgaImageState state() {
        return state;
    }

    /**
     * <p>
     * The date and time the AFI was created.
     * </p>
     * 
     * @return The date and time the AFI was created.
     */
    public Instant createTime() {
        return createTime;
    }

    /**
     * <p>
     * The time of the most recent update to the AFI.
     * </p>
     * 
     * @return The time of the most recent update to the AFI.
     */
    public Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The AWS account ID of the AFI owner.
     * </p>
     * 
     * @return The AWS account ID of the AFI owner.
     */
    public String ownerId() {
        return ownerId;
    }

    /**
     * <p>
     * The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
     * <code>aws-marketplace</code>.
     * </p>
     * 
     * @return The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
     *         <code>aws-marketplace</code>.
     */
    public String ownerAlias() {
        return ownerAlias;
    }

    /**
     * <p>
     * The product codes for the AFI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The product codes for the AFI.
     */
    public List<ProductCode> productCodes() {
        return productCodes;
    }

    /**
     * <p>
     * Any tags assigned to the AFI.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any tags assigned to the AFI.
     */
    public List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fpgaImageId() == null) ? 0 : fpgaImageId().hashCode());
        hashCode = 31 * hashCode + ((fpgaImageGlobalId() == null) ? 0 : fpgaImageGlobalId().hashCode());
        hashCode = 31 * hashCode + ((name() == null) ? 0 : name().hashCode());
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((shellVersion() == null) ? 0 : shellVersion().hashCode());
        hashCode = 31 * hashCode + ((pciId() == null) ? 0 : pciId().hashCode());
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((createTime() == null) ? 0 : createTime().hashCode());
        hashCode = 31 * hashCode + ((updateTime() == null) ? 0 : updateTime().hashCode());
        hashCode = 31 * hashCode + ((ownerId() == null) ? 0 : ownerId().hashCode());
        hashCode = 31 * hashCode + ((ownerAlias() == null) ? 0 : ownerAlias().hashCode());
        hashCode = 31 * hashCode + ((productCodes() == null) ? 0 : productCodes().hashCode());
        hashCode = 31 * hashCode + ((tags() == null) ? 0 : tags().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaImage)) {
            return false;
        }
        FpgaImage other = (FpgaImage) obj;
        if (other.fpgaImageId() == null ^ this.fpgaImageId() == null) {
            return false;
        }
        if (other.fpgaImageId() != null && !other.fpgaImageId().equals(this.fpgaImageId())) {
            return false;
        }
        if (other.fpgaImageGlobalId() == null ^ this.fpgaImageGlobalId() == null) {
            return false;
        }
        if (other.fpgaImageGlobalId() != null && !other.fpgaImageGlobalId().equals(this.fpgaImageGlobalId())) {
            return false;
        }
        if (other.name() == null ^ this.name() == null) {
            return false;
        }
        if (other.name() != null && !other.name().equals(this.name())) {
            return false;
        }
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.shellVersion() == null ^ this.shellVersion() == null) {
            return false;
        }
        if (other.shellVersion() != null && !other.shellVersion().equals(this.shellVersion())) {
            return false;
        }
        if (other.pciId() == null ^ this.pciId() == null) {
            return false;
        }
        if (other.pciId() != null && !other.pciId().equals(this.pciId())) {
            return false;
        }
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.createTime() == null ^ this.createTime() == null) {
            return false;
        }
        if (other.createTime() != null && !other.createTime().equals(this.createTime())) {
            return false;
        }
        if (other.updateTime() == null ^ this.updateTime() == null) {
            return false;
        }
        if (other.updateTime() != null && !other.updateTime().equals(this.updateTime())) {
            return false;
        }
        if (other.ownerId() == null ^ this.ownerId() == null) {
            return false;
        }
        if (other.ownerId() != null && !other.ownerId().equals(this.ownerId())) {
            return false;
        }
        if (other.ownerAlias() == null ^ this.ownerAlias() == null) {
            return false;
        }
        if (other.ownerAlias() != null && !other.ownerAlias().equals(this.ownerAlias())) {
            return false;
        }
        if (other.productCodes() == null ^ this.productCodes() == null) {
            return false;
        }
        if (other.productCodes() != null && !other.productCodes().equals(this.productCodes())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fpgaImageId() != null) {
            sb.append("FpgaImageId: ").append(fpgaImageId()).append(",");
        }
        if (fpgaImageGlobalId() != null) {
            sb.append("FpgaImageGlobalId: ").append(fpgaImageGlobalId()).append(",");
        }
        if (name() != null) {
            sb.append("Name: ").append(name()).append(",");
        }
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (shellVersion() != null) {
            sb.append("ShellVersion: ").append(shellVersion()).append(",");
        }
        if (pciId() != null) {
            sb.append("PciId: ").append(pciId()).append(",");
        }
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (createTime() != null) {
            sb.append("CreateTime: ").append(createTime()).append(",");
        }
        if (updateTime() != null) {
            sb.append("UpdateTime: ").append(updateTime()).append(",");
        }
        if (ownerId() != null) {
            sb.append("OwnerId: ").append(ownerId()).append(",");
        }
        if (ownerAlias() != null) {
            sb.append("OwnerAlias: ").append(ownerAlias()).append(",");
        }
        if (productCodes() != null) {
            sb.append("ProductCodes: ").append(productCodes()).append(",");
        }
        if (tags() != null) {
            sb.append("Tags: ").append(tags()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, FpgaImage> {
        /**
         * <p>
         * The FPGA image identifier (AFI ID).
         * </p>
         * 
         * @param fpgaImageId
         *        The FPGA image identifier (AFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageId(String fpgaImageId);

        /**
         * <p>
         * The global FPGA image identifier (AGFI ID).
         * </p>
         * 
         * @param fpgaImageGlobalId
         *        The global FPGA image identifier (AGFI ID).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImageGlobalId(String fpgaImageGlobalId);

        /**
         * <p>
         * The name of the AFI.
         * </p>
         * 
         * @param name
         *        The name of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the AFI.
         * </p>
         * 
         * @param description
         *        The description of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the AWS Shell that was used to create the bitstream.
         * </p>
         * 
         * @param shellVersion
         *        The version of the AWS Shell that was used to create the bitstream.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shellVersion(String shellVersion);

        /**
         * <p>
         * Information about the PCI bus.
         * </p>
         * 
         * @param pciId
         *        Information about the PCI bus.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pciId(PciId pciId);

        /**
         * <p>
         * Information about the state of the AFI.
         * </p>
         * 
         * @param state
         *        Information about the state of the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder state(FpgaImageState state);

        /**
         * <p>
         * The date and time the AFI was created.
         * </p>
         * 
         * @param createTime
         *        The date and time the AFI was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createTime(Instant createTime);

        /**
         * <p>
         * The time of the most recent update to the AFI.
         * </p>
         * 
         * @param updateTime
         *        The time of the most recent update to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The AWS account ID of the AFI owner.
         * </p>
         * 
         * @param ownerId
         *        The AWS account ID of the AFI owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerId(String ownerId);

        /**
         * <p>
         * The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
         * <code>aws-marketplace</code>.
         * </p>
         * 
         * @param ownerAlias
         *        The alias of the AFI owner. Possible values include <code>self</code>, <code>amazon</code>, and
         *        <code>aws-marketplace</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerAlias(String ownerAlias);

        /**
         * <p>
         * The product codes for the AFI.
         * </p>
         * 
         * @param productCodes
         *        The product codes for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(Collection<ProductCode> productCodes);

        /**
         * <p>
         * The product codes for the AFI.
         * </p>
         * 
         * @param productCodes
         *        The product codes for the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder productCodes(ProductCode... productCodes);

        /**
         * <p>
         * Any tags assigned to the AFI.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Any tags assigned to the AFI.
         * </p>
         * 
         * @param tags
         *        Any tags assigned to the AFI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);
    }

    private static final class BuilderImpl implements Builder {
        private String fpgaImageId;

        private String fpgaImageGlobalId;

        private String name;

        private String description;

        private String shellVersion;

        private PciId pciId;

        private FpgaImageState state;

        private Instant createTime;

        private Instant updateTime;

        private String ownerId;

        private String ownerAlias;

        private List<ProductCode> productCodes;

        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(FpgaImage model) {
            setFpgaImageId(model.fpgaImageId);
            setFpgaImageGlobalId(model.fpgaImageGlobalId);
            setName(model.name);
            setDescription(model.description);
            setShellVersion(model.shellVersion);
            setPciId(model.pciId);
            setState(model.state);
            setCreateTime(model.createTime);
            setUpdateTime(model.updateTime);
            setOwnerId(model.ownerId);
            setOwnerAlias(model.ownerAlias);
            setProductCodes(model.productCodes);
            setTags(model.tags);
        }

        public final String getFpgaImageId() {
            return fpgaImageId;
        }

        @Override
        public final Builder fpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
            return this;
        }

        public final void setFpgaImageId(String fpgaImageId) {
            this.fpgaImageId = fpgaImageId;
        }

        public final String getFpgaImageGlobalId() {
            return fpgaImageGlobalId;
        }

        @Override
        public final Builder fpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
            return this;
        }

        public final void setFpgaImageGlobalId(String fpgaImageGlobalId) {
            this.fpgaImageGlobalId = fpgaImageGlobalId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getShellVersion() {
            return shellVersion;
        }

        @Override
        public final Builder shellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
            return this;
        }

        public final void setShellVersion(String shellVersion) {
            this.shellVersion = shellVersion;
        }

        public final PciId getPciId() {
            return pciId;
        }

        @Override
        public final Builder pciId(PciId pciId) {
            this.pciId = pciId;
            return this;
        }

        public final void setPciId(PciId pciId) {
            this.pciId = pciId;
        }

        public final FpgaImageState getState() {
            return state;
        }

        @Override
        public final Builder state(FpgaImageState state) {
            this.state = state;
            return this;
        }

        public final void setState(FpgaImageState state) {
            this.state = state;
        }

        public final Instant getCreateTime() {
            return createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        public final String getOwnerId() {
            return ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        public final String getOwnerAlias() {
            return ownerAlias;
        }

        @Override
        public final Builder ownerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
            return this;
        }

        public final void setOwnerAlias(String ownerAlias) {
            this.ownerAlias = ownerAlias;
        }

        public final Collection<ProductCode> getProductCodes() {
            return productCodes;
        }

        @Override
        public final Builder productCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder productCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
            return this;
        }

        public final void setProductCodes(Collection<ProductCode> productCodes) {
            this.productCodes = ProductCodeListCopier.copy(productCodes);
        }

        @SafeVarargs
        public final void setProductCodes(ProductCode... productCodes) {
            productCodes(Arrays.asList(productCodes));
        }

        public final Collection<Tag> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
        }

        @SafeVarargs
        public final void setTags(Tag... tags) {
            tags(Arrays.asList(tags));
        }

        @Override
        public FpgaImage build() {
            return new FpgaImage(this);
        }
    }
}
