/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a disk image.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DiskImageDescription implements ToCopyableBuilder<DiskImageDescription.Builder, DiskImageDescription> {
    private final String checksum;

    private final String format;

    private final String importManifestUrl;

    private final Long size;

    private DiskImageDescription(BuilderImpl builder) {
        this.checksum = builder.checksum;
        this.format = builder.format;
        this.importManifestUrl = builder.importManifestUrl;
        this.size = builder.size;
    }

    /**
     * <p>
     * The checksum computed for the disk image.
     * </p>
     * 
     * @return The checksum computed for the disk image.
     */
    public String checksum() {
        return checksum;
    }

    /**
     * <p>
     * The disk image format.
     * </p>
     * 
     * @return The disk image format.
     * @see DiskImageFormat
     */
    public String format() {
        return format;
    }

    /**
     * <p>
     * A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL for
     * an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST Requests</a>
     * topic in the <i>Amazon Simple Storage Service Developer Guide</i>.
     * </p>
     * <p>
     * For information about the import manifest referenced by this API action, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     * </p>
     * 
     * @return A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned
     *         URL for an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
     *         Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
     *         <p>
     *         For information about the import manifest referenced by this API action, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
     */
    public String importManifestUrl() {
        return importManifestUrl;
    }

    /**
     * <p>
     * The size of the disk image, in GiB.
     * </p>
     * 
     * @return The size of the disk image, in GiB.
     */
    public Long size() {
        return size;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((checksum() == null) ? 0 : checksum().hashCode());
        hashCode = 31 * hashCode + ((format() == null) ? 0 : format().hashCode());
        hashCode = 31 * hashCode + ((importManifestUrl() == null) ? 0 : importManifestUrl().hashCode());
        hashCode = 31 * hashCode + ((size() == null) ? 0 : size().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DiskImageDescription)) {
            return false;
        }
        DiskImageDescription other = (DiskImageDescription) obj;
        if (other.checksum() == null ^ this.checksum() == null) {
            return false;
        }
        if (other.checksum() != null && !other.checksum().equals(this.checksum())) {
            return false;
        }
        if (other.format() == null ^ this.format() == null) {
            return false;
        }
        if (other.format() != null && !other.format().equals(this.format())) {
            return false;
        }
        if (other.importManifestUrl() == null ^ this.importManifestUrl() == null) {
            return false;
        }
        if (other.importManifestUrl() != null && !other.importManifestUrl().equals(this.importManifestUrl())) {
            return false;
        }
        if (other.size() == null ^ this.size() == null) {
            return false;
        }
        if (other.size() != null && !other.size().equals(this.size())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (checksum() != null) {
            sb.append("Checksum: ").append(checksum()).append(",");
        }
        if (format() != null) {
            sb.append("Format: ").append(format()).append(",");
        }
        if (importManifestUrl() != null) {
            sb.append("ImportManifestUrl: ").append(importManifestUrl()).append(",");
        }
        if (size() != null) {
            sb.append("Size: ").append(size()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DiskImageDescription> {
        /**
         * <p>
         * The checksum computed for the disk image.
         * </p>
         * 
         * @param checksum
         *        The checksum computed for the disk image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder checksum(String checksum);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param format
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder format(String format);

        /**
         * <p>
         * The disk image format.
         * </p>
         * 
         * @param format
         *        The disk image format.
         * @see DiskImageFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DiskImageFormat
         */
        Builder format(DiskImageFormat format);

        /**
         * <p>
         * A presigned URL for the import manifest stored in Amazon S3. For information about creating a presigned URL
         * for an Amazon S3 object, read the "Query String Request Authentication Alternative" section of the <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
         * Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.
         * </p>
         * <p>
         * For information about the import manifest referenced by this API action, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
         * </p>
         * 
         * @param importManifestUrl
         *        A presigned URL for the import manifest stored in Amazon S3. For information about creating a
         *        presigned URL for an Amazon S3 object, read the "Query String Request Authentication Alternative"
         *        section of the <a
         *        href="http://docs.aws.amazon.com/AmazonS3/latest/dev/RESTAuthentication.html">Authenticating REST
         *        Requests</a> topic in the <i>Amazon Simple Storage Service Developer Guide</i>.</p>
         *        <p>
         *        For information about the import manifest referenced by this API action, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html">VM Import Manifest</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importManifestUrl(String importManifestUrl);

        /**
         * <p>
         * The size of the disk image, in GiB.
         * </p>
         * 
         * @param size
         *        The size of the disk image, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder size(Long size);
    }

    private static final class BuilderImpl implements Builder {
        private String checksum;

        private String format;

        private String importManifestUrl;

        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DiskImageDescription model) {
            setChecksum(model.checksum);
            setFormat(model.format);
            setImportManifestUrl(model.importManifestUrl);
            setSize(model.size);
        }

        public final String getChecksum() {
            return checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(DiskImageFormat format) {
            this.format(format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final void setFormat(DiskImageFormat format) {
            this.format(format.toString());
        }

        public final String getImportManifestUrl() {
            return importManifestUrl;
        }

        @Override
        public final Builder importManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
            return this;
        }

        public final void setImportManifestUrl(String importManifestUrl) {
            this.importManifestUrl = importManifestUrl;
        }

        public final Long getSize() {
            return size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        @Override
        public DiskImageDescription build() {
            return new DiskImageDescription(this);
        }
    }
}
