/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpnConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpnConnectionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVpnConnectionsRequest.Builder, DescribeVpnConnectionsRequest> {
    private final List<Filter> filters;

    private final List<String> vpnConnectionIds;

    private DescribeVpnConnectionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpnConnectionIds = builder.vpnConnectionIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     * <code>deleting</code> | <code>deleted</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
     * devices that do not support Border Gateway Protocol (BGP).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used in a
     * customer data center.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-connection-id</code> - The ID of the VPN connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
     *         <code>deleting</code> | <code>deleted</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
     *         for devices that do not support Border Gateway Protocol (BGP).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
     *         used in a customer data center.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>
     *         .
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-connection-id</code> - The ID of the VPN connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more VPN connection IDs.
     * </p>
     * <p>
     * Default: Describes your VPN connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more VPN connection IDs.</p>
     *         <p>
     *         Default: Describes your VPN connections.
     */
    public List<String> vpnConnectionIds() {
        return vpnConnectionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((vpnConnectionIds() == null) ? 0 : vpnConnectionIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpnConnectionsRequest)) {
            return false;
        }
        DescribeVpnConnectionsRequest other = (DescribeVpnConnectionsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.vpnConnectionIds() == null ^ this.vpnConnectionIds() == null) {
            return false;
        }
        if (other.vpnConnectionIds() != null && !other.vpnConnectionIds().equals(this.vpnConnectionIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (vpnConnectionIds() != null) {
            sb.append("VpnConnectionIds: ").append(vpnConnectionIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpnConnectionsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         * <code>deleting</code> | <code>deleted</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used for
         * devices that do not support Border Gateway Protocol (BGP).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet used
         * in a customer data center.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>type</code> - The type of VPN connection. Currently the only supported type is <code>ipsec.1</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-connection-id</code> - The ID of the VPN connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>customer-gateway-configuration</code> - The configuration information for the customer gateway.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>customer-gateway-id</code> - The ID of a customer gateway associated with the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the VPN connection (<code>pending</code> | <code>available</code> |
         *        <code>deleting</code> | <code>deleted</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>option.static-routes-only</code> - Indicates whether the connection has static routes only. Used
         *        for devices that do not support Border Gateway Protocol (BGP).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>route.destination-cidr-block</code> - The destination CIDR block. This corresponds to the subnet
         *        used in a customer data center.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>bgp-asn</code> - The BGP Autonomous System Number (ASN) associated with a BGP device.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>type</code> - The type of VPN connection. Currently the only supported type is
         *        <code>ipsec.1</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-connection-id</code> - The ID of the VPN connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpn-gateway-id</code> - The ID of a virtual private gateway associated with the VPN connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(Collection<String> vpnConnectionIds);

        /**
         * <p>
         * One or more VPN connection IDs.
         * </p>
         * <p>
         * Default: Describes your VPN connections.
         * </p>
         * 
         * @param vpnConnectionIds
         *        One or more VPN connection IDs.</p>
         *        <p>
         *        Default: Describes your VPN connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpnConnectionIds(String... vpnConnectionIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> vpnConnectionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpnConnectionsRequest model) {
            setFilters(model.filters);
            setVpnConnectionIds(model.vpnConnectionIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Collection<String> getVpnConnectionIds() {
            return vpnConnectionIds;
        }

        @Override
        public final Builder vpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpnConnectionIds(String... vpnConnectionIds) {
            vpnConnectionIds(Arrays.asList(vpnConnectionIds));
            return this;
        }

        public final void setVpnConnectionIds(Collection<String> vpnConnectionIds) {
            this.vpnConnectionIds = VpnConnectionIdStringListCopier.copy(vpnConnectionIds);
        }

        @SafeVarargs
        public final void setVpnConnectionIds(String... vpnConnectionIds) {
            vpnConnectionIds(Arrays.asList(vpnConnectionIds));
        }

        @Override
        public DescribeVpnConnectionsRequest build() {
            return new DescribeVpnConnectionsRequest(this);
        }
    }
}
