/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcPeeringConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcPeeringConnectionsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpcPeeringConnectionsResponse.Builder, DescribeVpcPeeringConnectionsResponse> {
    private final List<VpcPeeringConnection> vpcPeeringConnections;

    private DescribeVpcPeeringConnectionsResponse(BuilderImpl builder) {
        this.vpcPeeringConnections = builder.vpcPeeringConnections;
    }

    /**
     * <p>
     * Information about the VPC peering connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the VPC peering connections.
     */
    public List<VpcPeeringConnection> vpcPeeringConnections() {
        return vpcPeeringConnections;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcPeeringConnections() == null) ? 0 : vpcPeeringConnections().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsResponse)) {
            return false;
        }
        DescribeVpcPeeringConnectionsResponse other = (DescribeVpcPeeringConnectionsResponse) obj;
        if (other.vpcPeeringConnections() == null ^ this.vpcPeeringConnections() == null) {
            return false;
        }
        if (other.vpcPeeringConnections() != null && !other.vpcPeeringConnections().equals(this.vpcPeeringConnections())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcPeeringConnections() != null) {
            sb.append("VpcPeeringConnections: ").append(vpcPeeringConnections()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcPeeringConnectionsResponse> {
        /**
         * <p>
         * Information about the VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        Information about the VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections);

        /**
         * <p>
         * Information about the VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnections
         *        Information about the VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections);
    }

    private static final class BuilderImpl implements Builder {
        private List<VpcPeeringConnection> vpcPeeringConnections;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsResponse model) {
            setVpcPeeringConnections(model.vpcPeeringConnections);
        }

        public final Collection<VpcPeeringConnection> getVpcPeeringConnections() {
            return vpcPeeringConnections;
        }

        @Override
        public final Builder vpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections) {
            vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
            return this;
        }

        public final void setVpcPeeringConnections(Collection<VpcPeeringConnection> vpcPeeringConnections) {
            this.vpcPeeringConnections = VpcPeeringConnectionListCopier.copy(vpcPeeringConnections);
        }

        @SafeVarargs
        public final void setVpcPeeringConnections(VpcPeeringConnection... vpcPeeringConnections) {
            vpcPeeringConnections(Arrays.asList(vpcPeeringConnections));
        }

        @Override
        public DescribeVpcPeeringConnectionsResponse build() {
            return new DescribeVpcPeeringConnectionsResponse(this);
        }
    }
}
