/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeVpcPeeringConnections.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcPeeringConnectionsRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeVpcPeeringConnectionsRequest.Builder, DescribeVpcPeeringConnectionsRequest> {
    private final List<Filter> filters;

    private final List<String> vpcPeeringConnectionIds;

    private DescribeVpcPeeringConnectionsRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.vpcPeeringConnectionIds = builder.vpcPeeringConnectionIds;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
     * <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
     * <code>deleted</code> | <code>rejected</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>status-message</code> - A message that provides more information about the status of the VPC peering
     * connection, if applicable.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource. Specify
     * the key of the tag in the filter name and the value of the tag in the filter value. For example, for the tag
     * Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter value.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value is),
     * and the tag value X (regardless of what the tag's key is). If you want to list only resources where Purpose is X,
     * see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     * <code>tag-key</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
     *         <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
     *         <code>deleted</code> | <code>rejected</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>status-message</code> - A message that provides more information about the status of the VPC
     *         peering connection, if applicable.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
     *         Specify the key of the tag in the filter name and the value of the tag in the filter value. For example,
     *         for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the
     *         filter value.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
     *         "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's
     *         value is), and the tag value X (regardless of what the tag's key is). If you want to list only resources
     *         where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
     *         <code>tag-key</code> filter.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * One or more VPC peering connection IDs.
     * </p>
     * <p>
     * Default: Describes all your VPC peering connections.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more VPC peering connection IDs.</p>
     *         <p>
     *         Default: Describes all your VPC peering connections.
     */
    public List<String> vpcPeeringConnectionIds() {
        return vpcPeeringConnectionIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((vpcPeeringConnectionIds() == null) ? 0 : vpcPeeringConnectionIds().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcPeeringConnectionsRequest)) {
            return false;
        }
        DescribeVpcPeeringConnectionsRequest other = (DescribeVpcPeeringConnectionsRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.vpcPeeringConnectionIds() == null ^ this.vpcPeeringConnectionIds() == null) {
            return false;
        }
        if (other.vpcPeeringConnectionIds() != null && !other.vpcPeeringConnectionIds().equals(this.vpcPeeringConnectionIds())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (vpcPeeringConnectionIds() != null) {
            sb.append("VpcPeeringConnectionIds: ").append(vpcPeeringConnectionIds()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcPeeringConnectionsRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
         * <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
         * <code>deleted</code> | <code>rejected</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - A message that provides more information about the status of the VPC peering
         * connection, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
         *        <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
         *        <code>deleted</code> | <code>rejected</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - A message that provides more information about the status of the VPC
         *        peering connection, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
         * <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
         * <code>deleted</code> | <code>rejected</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>status-message</code> - A message that provides more information about the status of the VPC peering
         * connection, if applicable.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the resource.
         * Specify the key of the tag in the filter name and the value of the tag in the filter value. For example, for
         * the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and <code>X</code> for the filter
         * value.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         * <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the filter
         * "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the tag's value
         * is), and the tag value X (regardless of what the tag's key is). If you want to list only resources where
         * Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of the
         * <code>tag-key</code> filter.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.cidr-block</code> - The IPv4 CIDR block of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.owner-id</code> - The AWS account ID of the owner of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>accepter-vpc-info.vpc-id</code> - The ID of the peer VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>expiration-time</code> - The expiration date and time for the VPC peering connection.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.cidr-block</code> - The IPv4 CIDR block of the requester's VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.owner-id</code> - The AWS account ID of the owner of the requester VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>requester-vpc-info.vpc-id</code> - The ID of the requester VPC.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-code</code> - The status of the VPC peering connection (<code>pending-acceptance</code> |
         *        <code>failed</code> | <code>expired</code> | <code>provisioning</code> | <code>active</code> |
         *        <code>deleted</code> | <code>rejected</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>status-message</code> - A message that provides more information about the status of the VPC
         *        peering connection, if applicable.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag</code>:<i>key</i>=<i>value</i> - The key/value combination of a tag assigned to the
         *        resource. Specify the key of the tag in the filter name and the value of the tag in the filter value.
         *        For example, for the tag Purpose=X, specify <code>tag:Purpose</code> for the filter name and
         *        <code>X</code> for the filter value.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-key</code> - The key of a tag assigned to the resource. This filter is independent of the
         *        <code>tag-value</code> filter. For example, if you use both the filter "tag-key=Purpose" and the
         *        filter "tag-value=X", you get any resources assigned both the tag key Purpose (regardless of what the
         *        tag's value is), and the tag value X (regardless of what the tag's key is). If you want to list only
         *        resources where Purpose is X, see the <code>tag</code>:<i>key</i>=<i>value</i> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>tag-value</code> - The value of a tag assigned to the resource. This filter is independent of
         *        the <code>tag-key</code> filter.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>vpc-peering-connection-id</code> - The ID of the VPC peering connection.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * One or more VPC peering connection IDs.
         * </p>
         * <p>
         * Default: Describes all your VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnectionIds
         *        One or more VPC peering connection IDs.</p>
         *        <p>
         *        Default: Describes all your VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds);

        /**
         * <p>
         * One or more VPC peering connection IDs.
         * </p>
         * <p>
         * Default: Describes all your VPC peering connections.
         * </p>
         * 
         * @param vpcPeeringConnectionIds
         *        One or more VPC peering connection IDs.</p>
         *        <p>
         *        Default: Describes all your VPC peering connections.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnectionIds(String... vpcPeeringConnectionIds);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> vpcPeeringConnectionIds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcPeeringConnectionsRequest model) {
            setFilters(model.filters);
            setVpcPeeringConnectionIds(model.vpcPeeringConnectionIds);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Collection<String> getVpcPeeringConnectionIds() {
            return vpcPeeringConnectionIds;
        }

        @Override
        public final Builder vpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
            this.vpcPeeringConnectionIds = ValueStringListCopier.copy(vpcPeeringConnectionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcPeeringConnectionIds(String... vpcPeeringConnectionIds) {
            vpcPeeringConnectionIds(Arrays.asList(vpcPeeringConnectionIds));
            return this;
        }

        public final void setVpcPeeringConnectionIds(Collection<String> vpcPeeringConnectionIds) {
            this.vpcPeeringConnectionIds = ValueStringListCopier.copy(vpcPeeringConnectionIds);
        }

        @SafeVarargs
        public final void setVpcPeeringConnectionIds(String... vpcPeeringConnectionIds) {
            vpcPeeringConnectionIds(Arrays.asList(vpcPeeringConnectionIds));
        }

        @Override
        public DescribeVpcPeeringConnectionsRequest build() {
            return new DescribeVpcPeeringConnectionsRequest(this);
        }
    }
}
