/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcEndpoints.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcEndpointsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpcEndpointsResponse.Builder, DescribeVpcEndpointsResponse> {
    private final String nextToken;

    private final List<VpcEndpoint> vpcEndpoints;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.vpcEndpoints = builder.vpcEndpoints;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the endpoints.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the endpoints.
     */
    public List<VpcEndpoint> vpcEndpoints() {
        return vpcEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((vpcEndpoints() == null) ? 0 : vpcEndpoints().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcEndpoints() == null ^ this.vpcEndpoints() == null) {
            return false;
        }
        if (other.vpcEndpoints() != null && !other.vpcEndpoints().equals(this.vpcEndpoints())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (vpcEndpoints() != null) {
            sb.append("VpcEndpoints: ").append(vpcEndpoints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the endpoints.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about the endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints);

        /**
         * <p>
         * Information about the endpoints.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about the endpoints.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(VpcEndpoint... vpcEndpoints);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<VpcEndpoint> vpcEndpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            setNextToken(model.nextToken);
            setVpcEndpoints(model.vpcEndpoints);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<VpcEndpoint> getVpcEndpoints() {
            return vpcEndpoints;
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint... vpcEndpoints) {
            vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointSetCopier.copy(vpcEndpoints);
        }

        @SafeVarargs
        public final void setVpcEndpoints(VpcEndpoint... vpcEndpoints) {
            vpcEndpoints(Arrays.asList(vpcEndpoints));
        }

        @Override
        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }
    }
}
