/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeVpcClassicLinkDnsSupport.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeVpcClassicLinkDnsSupportResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeVpcClassicLinkDnsSupportResponse.Builder, DescribeVpcClassicLinkDnsSupportResponse> {
    private final String nextToken;

    private final List<ClassicLinkDnsSupport> vpcs;

    private DescribeVpcClassicLinkDnsSupportResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.vpcs = builder.vpcs;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items.
     * </p>
     * 
     * @return The token to use when requesting the next set of items.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the ClassicLink DNS support status of the VPCs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the ClassicLink DNS support status of the VPCs.
     */
    public List<ClassicLinkDnsSupport> vpcs() {
        return vpcs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((vpcs() == null) ? 0 : vpcs().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcClassicLinkDnsSupportResponse)) {
            return false;
        }
        DescribeVpcClassicLinkDnsSupportResponse other = (DescribeVpcClassicLinkDnsSupportResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.vpcs() == null ^ this.vpcs() == null) {
            return false;
        }
        if (other.vpcs() != null && !other.vpcs().equals(this.vpcs())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (vpcs() != null) {
            sb.append("Vpcs: ").append(vpcs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeVpcClassicLinkDnsSupportResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the ClassicLink DNS support status of the VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about the ClassicLink DNS support status of the VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs);

        /**
         * <p>
         * Information about the ClassicLink DNS support status of the VPCs.
         * </p>
         * 
         * @param vpcs
         *        Information about the ClassicLink DNS support status of the VPCs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcs(ClassicLinkDnsSupport... vpcs);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<ClassicLinkDnsSupport> vpcs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcClassicLinkDnsSupportResponse model) {
            setNextToken(model.nextToken);
            setVpcs(model.vpcs);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<ClassicLinkDnsSupport> getVpcs() {
            return vpcs;
        }

        @Override
        public final Builder vpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcs(ClassicLinkDnsSupport... vpcs) {
            vpcs(Arrays.asList(vpcs));
            return this;
        }

        public final void setVpcs(Collection<ClassicLinkDnsSupport> vpcs) {
            this.vpcs = ClassicLinkDnsSupportListCopier.copy(vpcs);
        }

        @SafeVarargs
        public final void setVpcs(ClassicLinkDnsSupport... vpcs) {
            vpcs(Arrays.asList(vpcs));
        }

        @Override
        public DescribeVpcClassicLinkDnsSupportResponse build() {
            return new DescribeVpcClassicLinkDnsSupportResponse(this);
        }
    }
}
