/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeStaleSecurityGroupsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeStaleSecurityGroupsResponse.Builder, DescribeStaleSecurityGroupsResponse> {
    private final String nextToken;

    private final List<StaleSecurityGroup> staleSecurityGroupSet;

    private DescribeStaleSecurityGroupsResponse(BuilderImpl builder) {
        this.nextToken = builder.nextToken;
        this.staleSecurityGroupSet = builder.staleSecurityGroupSet;
    }

    /**
     * <p>
     * The token to use when requesting the next set of items. If there are no additional items to return, the string is
     * empty.
     * </p>
     * 
     * @return The token to use when requesting the next set of items. If there are no additional items to return, the
     *         string is empty.
     */
    public String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Information about the stale security groups.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the stale security groups.
     */
    public List<StaleSecurityGroup> staleSecurityGroupSet() {
        return staleSecurityGroupSet;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        hashCode = 31 * hashCode + ((staleSecurityGroupSet() == null) ? 0 : staleSecurityGroupSet().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeStaleSecurityGroupsResponse)) {
            return false;
        }
        DescribeStaleSecurityGroupsResponse other = (DescribeStaleSecurityGroupsResponse) obj;
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        if (other.staleSecurityGroupSet() == null ^ this.staleSecurityGroupSet() == null) {
            return false;
        }
        if (other.staleSecurityGroupSet() != null && !other.staleSecurityGroupSet().equals(this.staleSecurityGroupSet())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        if (staleSecurityGroupSet() != null) {
            sb.append("StaleSecurityGroupSet: ").append(staleSecurityGroupSet()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeStaleSecurityGroupsResponse> {
        /**
         * <p>
         * The token to use when requesting the next set of items. If there are no additional items to return, the
         * string is empty.
         * </p>
         * 
         * @param nextToken
         *        The token to use when requesting the next set of items. If there are no additional items to return,
         *        the string is empty.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet);

        /**
         * <p>
         * Information about the stale security groups.
         * </p>
         * 
         * @param staleSecurityGroupSet
         *        Information about the stale security groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet);
    }

    private static final class BuilderImpl implements Builder {
        private String nextToken;

        private List<StaleSecurityGroup> staleSecurityGroupSet;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeStaleSecurityGroupsResponse model) {
            setNextToken(model.nextToken);
            setStaleSecurityGroupSet(model.staleSecurityGroupSet);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<StaleSecurityGroup> getStaleSecurityGroupSet() {
            return staleSecurityGroupSet;
        }

        @Override
        public final Builder staleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder staleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet) {
            staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
            return this;
        }

        public final void setStaleSecurityGroupSet(Collection<StaleSecurityGroup> staleSecurityGroupSet) {
            this.staleSecurityGroupSet = StaleSecurityGroupSetCopier.copy(staleSecurityGroupSet);
        }

        @SafeVarargs
        public final void setStaleSecurityGroupSet(StaleSecurityGroup... staleSecurityGroupSet) {
            staleSecurityGroupSet(Arrays.asList(staleSecurityGroupSet));
        }

        @Override
        public DescribeStaleSecurityGroupsResponse build() {
            return new DescribeStaleSecurityGroupsResponse(this);
        }
    }
}
