/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeRouteTables.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeRouteTablesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeRouteTablesResponse.Builder, DescribeRouteTablesResponse> {
    private final List<RouteTable> routeTables;

    private DescribeRouteTablesResponse(BuilderImpl builder) {
        this.routeTables = builder.routeTables;
    }

    /**
     * <p>
     * Information about one or more route tables.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more route tables.
     */
    public List<RouteTable> routeTables() {
        return routeTables;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((routeTables() == null) ? 0 : routeTables().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRouteTablesResponse)) {
            return false;
        }
        DescribeRouteTablesResponse other = (DescribeRouteTablesResponse) obj;
        if (other.routeTables() == null ^ this.routeTables() == null) {
            return false;
        }
        if (other.routeTables() != null && !other.routeTables().equals(this.routeTables())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (routeTables() != null) {
            sb.append("RouteTables: ").append(routeTables()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeRouteTablesResponse> {
        /**
         * <p>
         * Information about one or more route tables.
         * </p>
         * 
         * @param routeTables
         *        Information about one or more route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTables(Collection<RouteTable> routeTables);

        /**
         * <p>
         * Information about one or more route tables.
         * </p>
         * 
         * @param routeTables
         *        Information about one or more route tables.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder routeTables(RouteTable... routeTables);
    }

    private static final class BuilderImpl implements Builder {
        private List<RouteTable> routeTables;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRouteTablesResponse model) {
            setRouteTables(model.routeTables);
        }

        public final Collection<RouteTable> getRouteTables() {
            return routeTables;
        }

        @Override
        public final Builder routeTables(Collection<RouteTable> routeTables) {
            this.routeTables = RouteTableListCopier.copy(routeTables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder routeTables(RouteTable... routeTables) {
            routeTables(Arrays.asList(routeTables));
            return this;
        }

        public final void setRouteTables(Collection<RouteTable> routeTables) {
            this.routeTables = RouteTableListCopier.copy(routeTables);
        }

        @SafeVarargs
        public final void setRouteTables(RouteTable... routeTables) {
            routeTables(Arrays.asList(routeTables));
        }

        @Override
        public DescribeRouteTablesResponse build() {
            return new DescribeRouteTablesResponse(this);
        }
    }
}
