/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeIdentityIdFormat.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeIdentityIdFormatRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeIdentityIdFormatRequest.Builder, DescribeIdentityIdFormatRequest> {
    private final String principalArn;

    private final String resource;

    private DescribeIdentityIdFormatRequest(BuilderImpl builder) {
        this.principalArn = builder.principalArn;
        this.resource = builder.resource;
    }

    /**
     * <p>
     * The ARN of the principal, which can be an IAM role, IAM user, or the root user.
     * </p>
     * 
     * @return The ARN of the principal, which can be an IAM role, IAM user, or the root user.
     */
    public String principalArn() {
        return principalArn;
    }

    /**
     * <p>
     * The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
     * <code>volume</code>
     * </p>
     * 
     * @return The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
     *         <code>volume</code>
     */
    public String resource() {
        return resource;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((principalArn() == null) ? 0 : principalArn().hashCode());
        hashCode = 31 * hashCode + ((resource() == null) ? 0 : resource().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeIdentityIdFormatRequest)) {
            return false;
        }
        DescribeIdentityIdFormatRequest other = (DescribeIdentityIdFormatRequest) obj;
        if (other.principalArn() == null ^ this.principalArn() == null) {
            return false;
        }
        if (other.principalArn() != null && !other.principalArn().equals(this.principalArn())) {
            return false;
        }
        if (other.resource() == null ^ this.resource() == null) {
            return false;
        }
        if (other.resource() != null && !other.resource().equals(this.resource())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (principalArn() != null) {
            sb.append("PrincipalArn: ").append(principalArn()).append(",");
        }
        if (resource() != null) {
            sb.append("Resource: ").append(resource()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeIdentityIdFormatRequest> {
        /**
         * <p>
         * The ARN of the principal, which can be an IAM role, IAM user, or the root user.
         * </p>
         * 
         * @param principalArn
         *        The ARN of the principal, which can be an IAM role, IAM user, or the root user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalArn(String principalArn);

        /**
         * <p>
         * The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
         * <code>volume</code>
         * </p>
         * 
         * @param resource
         *        The type of resource: <code>instance</code> | <code>reservation</code> | <code>snapshot</code> |
         *        <code>volume</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);
    }

    private static final class BuilderImpl implements Builder {
        private String principalArn;

        private String resource;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeIdentityIdFormatRequest model) {
            setPrincipalArn(model.principalArn);
            setResource(model.resource);
        }

        public final String getPrincipalArn() {
            return principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public DescribeIdentityIdFormatRequest build() {
            return new DescribeIdentityIdFormatRequest(this);
        }
    }
}
