/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of DescribeHosts.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeHostsResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeHostsResponse.Builder, DescribeHostsResponse> {
    private final List<Host> hosts;

    private final String nextToken;

    private DescribeHostsResponse(BuilderImpl builder) {
        this.hosts = builder.hosts;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about the Dedicated Hosts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Dedicated Hosts.
     */
    public List<Host> hosts() {
        return hosts;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((hosts() == null) ? 0 : hosts().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHostsResponse)) {
            return false;
        }
        DescribeHostsResponse other = (DescribeHostsResponse) obj;
        if (other.hosts() == null ^ this.hosts() == null) {
            return false;
        }
        if (other.hosts() != null && !other.hosts().equals(this.hosts())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (hosts() != null) {
            sb.append("Hosts: ").append(hosts()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeHostsResponse> {
        /**
         * <p>
         * Information about the Dedicated Hosts.
         * </p>
         * 
         * @param hosts
         *        Information about the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Collection<Host> hosts);

        /**
         * <p>
         * Information about the Dedicated Hosts.
         * </p>
         * 
         * @param hosts
         *        Information about the Dedicated Hosts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hosts(Host... hosts);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<Host> hosts;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHostsResponse model) {
            setHosts(model.hosts);
            setNextToken(model.nextToken);
        }

        public final Collection<Host> getHosts() {
            return hosts;
        }

        @Override
        public final Builder hosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hosts(Host... hosts) {
            hosts(Arrays.asList(hosts));
            return this;
        }

        public final void setHosts(Collection<Host> hosts) {
            this.hosts = HostListCopier.copy(hosts);
        }

        @SafeVarargs
        public final void setHosts(Host... hosts) {
            hosts(Arrays.asList(hosts));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeHostsResponse build() {
            return new DescribeHostsResponse(this);
        }
    }
}
