/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeFpgaImagesResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<DescribeFpgaImagesResponse.Builder, DescribeFpgaImagesResponse> {
    private final List<FpgaImage> fpgaImages;

    private final String nextToken;

    private DescribeFpgaImagesResponse(BuilderImpl builder) {
        this.fpgaImages = builder.fpgaImages;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Information about one or more FPGA images.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about one or more FPGA images.
     */
    public List<FpgaImage> fpgaImages() {
        return fpgaImages;
    }

    /**
     * <p>
     * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
     * results to return.
     * </p>
     * 
     * @return The token to use to retrieve the next page of results. This value is <code>null</code> when there are no
     *         more results to return.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((fpgaImages() == null) ? 0 : fpgaImages().hashCode());
        hashCode = 31 * hashCode + ((nextToken() == null) ? 0 : nextToken().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeFpgaImagesResponse)) {
            return false;
        }
        DescribeFpgaImagesResponse other = (DescribeFpgaImagesResponse) obj;
        if (other.fpgaImages() == null ^ this.fpgaImages() == null) {
            return false;
        }
        if (other.fpgaImages() != null && !other.fpgaImages().equals(this.fpgaImages())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        if (other.nextToken() != null && !other.nextToken().equals(this.nextToken())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (fpgaImages() != null) {
            sb.append("FpgaImages: ").append(fpgaImages()).append(",");
        }
        if (nextToken() != null) {
            sb.append("NextToken: ").append(nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeFpgaImagesResponse> {
        /**
         * <p>
         * Information about one or more FPGA images.
         * </p>
         * 
         * @param fpgaImages
         *        Information about one or more FPGA images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImages(Collection<FpgaImage> fpgaImages);

        /**
         * <p>
         * Information about one or more FPGA images.
         * </p>
         * 
         * @param fpgaImages
         *        Information about one or more FPGA images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fpgaImages(FpgaImage... fpgaImages);

        /**
         * <p>
         * The token to use to retrieve the next page of results. This value is <code>null</code> when there are no more
         * results to return.
         * </p>
         * 
         * @param nextToken
         *        The token to use to retrieve the next page of results. This value is <code>null</code> when there are
         *        no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    private static final class BuilderImpl implements Builder {
        private List<FpgaImage> fpgaImages;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeFpgaImagesResponse model) {
            setFpgaImages(model.fpgaImages);
            setNextToken(model.nextToken);
        }

        public final Collection<FpgaImage> getFpgaImages() {
            return fpgaImages;
        }

        @Override
        public final Builder fpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fpgaImages(FpgaImage... fpgaImages) {
            fpgaImages(Arrays.asList(fpgaImages));
            return this;
        }

        public final void setFpgaImages(Collection<FpgaImage> fpgaImages) {
            this.fpgaImages = FpgaImageListCopier.copy(fpgaImages);
        }

        @SafeVarargs
        public final void setFpgaImages(FpgaImage... fpgaImages) {
            fpgaImages(Arrays.asList(fpgaImages));
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeFpgaImagesResponse build() {
            return new DescribeFpgaImagesResponse(this);
        }
    }
}
