/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for DescribeAvailabilityZones.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class DescribeAvailabilityZonesRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<DescribeAvailabilityZonesRequest.Builder, DescribeAvailabilityZonesRequest> {
    private final List<Filter> filters;

    private final List<String> zoneNames;

    private DescribeAvailabilityZonesRequest(BuilderImpl builder) {
        this.filters = builder.filters;
        this.zoneNames = builder.zoneNames;
    }

    /**
     * <p>
     * One or more filters.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>message</code> - Information about the Availability Zone.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>region-name</code> - The name of the region for the Availability Zone (for example, <code>us-east-1</code>
     * ).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
     * <code>impaired</code> | <code>unavailable</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return One or more filters.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>message</code> - Information about the Availability Zone.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>region-name</code> - The name of the region for the Availability Zone (for example,
     *         <code>us-east-1</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>state</code> - The state of the Availability Zone (<code>available</code> |
     *         <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
     *         </p>
     *         </li>
     */
    public List<Filter> filters() {
        return filters;
    }

    /**
     * <p>
     * The names of one or more Availability Zones.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The names of one or more Availability Zones.
     */
    public List<String> zoneNames() {
        return zoneNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((filters() == null) ? 0 : filters().hashCode());
        hashCode = 31 * hashCode + ((zoneNames() == null) ? 0 : zoneNames().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAvailabilityZonesRequest)) {
            return false;
        }
        DescribeAvailabilityZonesRequest other = (DescribeAvailabilityZonesRequest) obj;
        if (other.filters() == null ^ this.filters() == null) {
            return false;
        }
        if (other.filters() != null && !other.filters().equals(this.filters())) {
            return false;
        }
        if (other.zoneNames() == null ^ this.zoneNames() == null) {
            return false;
        }
        if (other.zoneNames() != null && !other.zoneNames().equals(this.zoneNames())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (filters() != null) {
            sb.append("Filters: ").append(filters()).append(",");
        }
        if (zoneNames() != null) {
            sb.append("ZoneNames: ").append(zoneNames()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, DescribeAvailabilityZonesRequest> {
        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>message</code> - Information about the Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region for the Availability Zone (for example,
         * <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
         * <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>message</code> - Information about the Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region for the Availability Zone (for example,
         *        <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone (<code>available</code> |
         *        <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<Filter> filters);

        /**
         * <p>
         * One or more filters.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>message</code> - Information about the Availability Zone.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>region-name</code> - The name of the region for the Availability Zone (for example,
         * <code>us-east-1</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>state</code> - The state of the Availability Zone (<code>available</code> | <code>information</code> |
         * <code>impaired</code> | <code>unavailable</code>).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         * </p>
         * </li>
         * </ul>
         * 
         * @param filters
         *        One or more filters.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>message</code> - Information about the Availability Zone.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>region-name</code> - The name of the region for the Availability Zone (for example,
         *        <code>us-east-1</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>state</code> - The state of the Availability Zone (<code>available</code> |
         *        <code>information</code> | <code>impaired</code> | <code>unavailable</code>).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>zone-name</code> - The name of the Availability Zone (for example, <code>us-east-1a</code>).
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Filter... filters);

        /**
         * <p>
         * The names of one or more Availability Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(Collection<String> zoneNames);

        /**
         * <p>
         * The names of one or more Availability Zones.
         * </p>
         * 
         * @param zoneNames
         *        The names of one or more Availability Zones.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneNames(String... zoneNames);
    }

    private static final class BuilderImpl implements Builder {
        private List<Filter> filters;

        private List<String> zoneNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAvailabilityZonesRequest model) {
            setFilters(model.filters);
            setZoneNames(model.zoneNames);
        }

        public final Collection<Filter> getFilters() {
            return filters;
        }

        @Override
        public final Builder filters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Filter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        public final void setFilters(Collection<Filter> filters) {
            this.filters = FilterListCopier.copy(filters);
        }

        @SafeVarargs
        public final void setFilters(Filter... filters) {
            filters(Arrays.asList(filters));
        }

        public final Collection<String> getZoneNames() {
            return zoneNames;
        }

        @Override
        public final Builder zoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder zoneNames(String... zoneNames) {
            zoneNames(Arrays.asList(zoneNames));
            return this;
        }

        public final void setZoneNames(Collection<String> zoneNames) {
            this.zoneNames = ZoneNameStringListCopier.copy(zoneNames);
        }

        @SafeVarargs
        public final void setZoneNames(String... zoneNames) {
            zoneNames(Arrays.asList(zoneNames));
        }

        @Override
        public DescribeAvailabilityZonesRequest build() {
            return new DescribeAvailabilityZonesRequest(this);
        }
    }
}
