/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateVpcPeeringConnectionRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateVpcPeeringConnectionRequest.Builder, CreateVpcPeeringConnectionRequest> {
    private final String peerOwnerId;

    private final String peerVpcId;

    private final String vpcId;

    private CreateVpcPeeringConnectionRequest(BuilderImpl builder) {
        this.peerOwnerId = builder.peerOwnerId;
        this.peerVpcId = builder.peerVpcId;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The AWS account ID of the owner of the peer VPC.
     * </p>
     * <p>
     * Default: Your AWS account ID
     * </p>
     * 
     * @return The AWS account ID of the owner of the peer VPC.</p>
     *         <p>
     *         Default: Your AWS account ID
     */
    public String peerOwnerId() {
        return peerOwnerId;
    }

    /**
     * <p>
     * The ID of the VPC with which you are creating the VPC peering connection.
     * </p>
     * 
     * @return The ID of the VPC with which you are creating the VPC peering connection.
     */
    public String peerVpcId() {
        return peerVpcId;
    }

    /**
     * <p>
     * The ID of the requester VPC.
     * </p>
     * 
     * @return The ID of the requester VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((peerOwnerId() == null) ? 0 : peerOwnerId().hashCode());
        hashCode = 31 * hashCode + ((peerVpcId() == null) ? 0 : peerVpcId().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVpcPeeringConnectionRequest)) {
            return false;
        }
        CreateVpcPeeringConnectionRequest other = (CreateVpcPeeringConnectionRequest) obj;
        if (other.peerOwnerId() == null ^ this.peerOwnerId() == null) {
            return false;
        }
        if (other.peerOwnerId() != null && !other.peerOwnerId().equals(this.peerOwnerId())) {
            return false;
        }
        if (other.peerVpcId() == null ^ this.peerVpcId() == null) {
            return false;
        }
        if (other.peerVpcId() != null && !other.peerVpcId().equals(this.peerVpcId())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (peerOwnerId() != null) {
            sb.append("PeerOwnerId: ").append(peerOwnerId()).append(",");
        }
        if (peerVpcId() != null) {
            sb.append("PeerVpcId: ").append(peerVpcId()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateVpcPeeringConnectionRequest> {
        /**
         * <p>
         * The AWS account ID of the owner of the peer VPC.
         * </p>
         * <p>
         * Default: Your AWS account ID
         * </p>
         * 
         * @param peerOwnerId
         *        The AWS account ID of the owner of the peer VPC.</p>
         *        <p>
         *        Default: Your AWS account ID
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerOwnerId(String peerOwnerId);

        /**
         * <p>
         * The ID of the VPC with which you are creating the VPC peering connection.
         * </p>
         * 
         * @param peerVpcId
         *        The ID of the VPC with which you are creating the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerVpcId(String peerVpcId);

        /**
         * <p>
         * The ID of the requester VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the requester VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String peerOwnerId;

        private String peerVpcId;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateVpcPeeringConnectionRequest model) {
            setPeerOwnerId(model.peerOwnerId);
            setPeerVpcId(model.peerVpcId);
            setVpcId(model.vpcId);
        }

        public final String getPeerOwnerId() {
            return peerOwnerId;
        }

        @Override
        public final Builder peerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
            return this;
        }

        public final void setPeerOwnerId(String peerOwnerId) {
            this.peerOwnerId = peerOwnerId;
        }

        public final String getPeerVpcId() {
            return peerVpcId;
        }

        @Override
        public final Builder peerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
            return this;
        }

        public final void setPeerVpcId(String peerVpcId) {
            this.peerVpcId = peerVpcId;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public CreateVpcPeeringConnectionRequest build() {
            return new CreateVpcPeeringConnectionRequest(this);
        }
    }
}
