/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateSubnet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateSubnetRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateSubnetRequest.Builder, CreateSubnetRequest> {
    private final String availabilityZone;

    private final String cidrBlock;

    private final String ipv6CidrBlock;

    private final String vpcId;

    private CreateSubnetRequest(BuilderImpl builder) {
        this.availabilityZone = builder.availabilityZone;
        this.cidrBlock = builder.cidrBlock;
        this.ipv6CidrBlock = builder.ipv6CidrBlock;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The Availability Zone for the subnet.
     * </p>
     * <p>
     * Default: AWS selects one for you. If you create more than one subnet in your VPC, we may not necessarily select a
     * different zone for each subnet.
     * </p>
     * 
     * @return The Availability Zone for the subnet.</p>
     *         <p>
     *         Default: AWS selects one for you. If you create more than one subnet in your VPC, we may not necessarily
     *         select a different zone for each subnet.
     */
    public String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>.
     * </p>
     * 
     * @return The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>.
     */
    public String cidrBlock() {
        return cidrBlock;
    }

    /**
     * <p>
     * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
     * </p>
     * 
     * @return The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
     */
    public String ipv6CidrBlock() {
        return ipv6CidrBlock;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availabilityZone() == null) ? 0 : availabilityZone().hashCode());
        hashCode = 31 * hashCode + ((cidrBlock() == null) ? 0 : cidrBlock().hashCode());
        hashCode = 31 * hashCode + ((ipv6CidrBlock() == null) ? 0 : ipv6CidrBlock().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSubnetRequest)) {
            return false;
        }
        CreateSubnetRequest other = (CreateSubnetRequest) obj;
        if (other.availabilityZone() == null ^ this.availabilityZone() == null) {
            return false;
        }
        if (other.availabilityZone() != null && !other.availabilityZone().equals(this.availabilityZone())) {
            return false;
        }
        if (other.cidrBlock() == null ^ this.cidrBlock() == null) {
            return false;
        }
        if (other.cidrBlock() != null && !other.cidrBlock().equals(this.cidrBlock())) {
            return false;
        }
        if (other.ipv6CidrBlock() == null ^ this.ipv6CidrBlock() == null) {
            return false;
        }
        if (other.ipv6CidrBlock() != null && !other.ipv6CidrBlock().equals(this.ipv6CidrBlock())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(availabilityZone()).append(",");
        }
        if (cidrBlock() != null) {
            sb.append("CidrBlock: ").append(cidrBlock()).append(",");
        }
        if (ipv6CidrBlock() != null) {
            sb.append("Ipv6CidrBlock: ").append(ipv6CidrBlock()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateSubnetRequest> {
        /**
         * <p>
         * The Availability Zone for the subnet.
         * </p>
         * <p>
         * Default: AWS selects one for you. If you create more than one subnet in your VPC, we may not necessarily
         * select a different zone for each subnet.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone for the subnet.</p>
         *        <p>
         *        Default: AWS selects one for you. If you create more than one subnet in your VPC, we may not
         *        necessarily select a different zone for each subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>.
         * </p>
         * 
         * @param cidrBlock
         *        The IPv4 network range for the subnet, in CIDR notation. For example, <code>10.0.0.0/24</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cidrBlock(String cidrBlock);

        /**
         * <p>
         * The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
         * </p>
         * 
         * @param ipv6CidrBlock
         *        The IPv6 network range for the subnet, in CIDR notation. The subnet size must use a /64 prefix length.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ipv6CidrBlock(String ipv6CidrBlock);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private String availabilityZone;

        private String cidrBlock;

        private String ipv6CidrBlock;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSubnetRequest model) {
            setAvailabilityZone(model.availabilityZone);
            setCidrBlock(model.cidrBlock);
            setIpv6CidrBlock(model.ipv6CidrBlock);
            setVpcId(model.vpcId);
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final String getCidrBlock() {
            return cidrBlock;
        }

        @Override
        public final Builder cidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
            return this;
        }

        public final void setCidrBlock(String cidrBlock) {
            this.cidrBlock = cidrBlock;
        }

        public final String getIpv6CidrBlock() {
            return ipv6CidrBlock;
        }

        @Override
        public final Builder ipv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
            return this;
        }

        public final void setIpv6CidrBlock(String ipv6CidrBlock) {
            this.ipv6CidrBlock = ipv6CidrBlock;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public CreateSubnetRequest build() {
            return new CreateSubnetRequest(this);
        }
    }
}
