/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateReservedInstancesListing.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateReservedInstancesListingResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateReservedInstancesListingResponse.Builder, CreateReservedInstancesListingResponse> {
    private final List<ReservedInstancesListing> reservedInstancesListings;

    private CreateReservedInstancesListingResponse(BuilderImpl builder) {
        this.reservedInstancesListings = builder.reservedInstancesListings;
    }

    /**
     * <p>
     * Information about the Standard Reserved Instance listing.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Information about the Standard Reserved Instance listing.
     */
    public List<ReservedInstancesListing> reservedInstancesListings() {
        return reservedInstancesListings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((reservedInstancesListings() == null) ? 0 : reservedInstancesListings().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateReservedInstancesListingResponse)) {
            return false;
        }
        CreateReservedInstancesListingResponse other = (CreateReservedInstancesListingResponse) obj;
        if (other.reservedInstancesListings() == null ^ this.reservedInstancesListings() == null) {
            return false;
        }
        if (other.reservedInstancesListings() != null
                && !other.reservedInstancesListings().equals(this.reservedInstancesListings())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (reservedInstancesListings() != null) {
            sb.append("ReservedInstancesListings: ").append(reservedInstancesListings()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateReservedInstancesListingResponse> {
        /**
         * <p>
         * Information about the Standard Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Standard Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings);

        /**
         * <p>
         * Information about the Standard Reserved Instance listing.
         * </p>
         * 
         * @param reservedInstancesListings
         *        Information about the Standard Reserved Instance listing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings);
    }

    private static final class BuilderImpl implements Builder {
        private List<ReservedInstancesListing> reservedInstancesListings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateReservedInstancesListingResponse model) {
            setReservedInstancesListings(model.reservedInstancesListings);
        }

        public final Collection<ReservedInstancesListing> getReservedInstancesListings() {
            return reservedInstancesListings;
        }

        @Override
        public final Builder reservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedInstancesListings(ReservedInstancesListing... reservedInstancesListings) {
            reservedInstancesListings(Arrays.asList(reservedInstancesListings));
            return this;
        }

        public final void setReservedInstancesListings(Collection<ReservedInstancesListing> reservedInstancesListings) {
            this.reservedInstancesListings = ReservedInstancesListingListCopier.copy(reservedInstancesListings);
        }

        @SafeVarargs
        public final void setReservedInstancesListings(ReservedInstancesListing... reservedInstancesListings) {
            reservedInstancesListings(Arrays.asList(reservedInstancesListings));
        }

        @Override
        public CreateReservedInstancesListingResponse build() {
            return new CreateReservedInstancesListingResponse(this);
        }
    }
}
