/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of CreateInternetGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateInternetGatewayResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<CreateInternetGatewayResponse.Builder, CreateInternetGatewayResponse> {
    private final InternetGateway internetGateway;

    private CreateInternetGatewayResponse(BuilderImpl builder) {
        this.internetGateway = builder.internetGateway;
    }

    /**
     * <p>
     * Information about the Internet gateway.
     * </p>
     * 
     * @return Information about the Internet gateway.
     */
    public InternetGateway internetGateway() {
        return internetGateway;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((internetGateway() == null) ? 0 : internetGateway().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInternetGatewayResponse)) {
            return false;
        }
        CreateInternetGatewayResponse other = (CreateInternetGatewayResponse) obj;
        if (other.internetGateway() == null ^ this.internetGateway() == null) {
            return false;
        }
        if (other.internetGateway() != null && !other.internetGateway().equals(this.internetGateway())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (internetGateway() != null) {
            sb.append("InternetGateway: ").append(internetGateway()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateInternetGatewayResponse> {
        /**
         * <p>
         * Information about the Internet gateway.
         * </p>
         * 
         * @param internetGateway
         *        Information about the Internet gateway.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder internetGateway(InternetGateway internetGateway);
    }

    private static final class BuilderImpl implements Builder {
        private InternetGateway internetGateway;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInternetGatewayResponse model) {
            setInternetGateway(model.internetGateway);
        }

        public final InternetGateway getInternetGateway() {
            return internetGateway;
        }

        @Override
        public final Builder internetGateway(InternetGateway internetGateway) {
            this.internetGateway = internetGateway;
            return this;
        }

        public final void setInternetGateway(InternetGateway internetGateway) {
            this.internetGateway = internetGateway;
        }

        @Override
        public CreateInternetGatewayResponse build() {
            return new CreateInternetGatewayResponse(this);
        }
    }
}
