/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CreateCustomerGateway.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CreateCustomerGatewayRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CreateCustomerGatewayRequest.Builder, CreateCustomerGatewayRequest> {
    private final Integer bgpAsn;

    private final String publicIp;

    private final String type;

    private CreateCustomerGatewayRequest(BuilderImpl builder) {
        this.bgpAsn = builder.bgpAsn;
        this.publicIp = builder.publicIp;
        this.type = builder.type;
    }

    /**
     * <p>
     * For devices that support BGP, the customer gateway's BGP ASN.
     * </p>
     * <p>
     * Default: 65000
     * </p>
     * 
     * @return For devices that support BGP, the customer gateway's BGP ASN.</p>
     *         <p>
     *         Default: 65000
     */
    public Integer bgpAsn() {
        return bgpAsn;
    }

    /**
     * <p>
     * The Internet-routable IP address for the customer gateway's outside interface. The address must be static.
     * </p>
     * 
     * @return The Internet-routable IP address for the customer gateway's outside interface. The address must be
     *         static.
     */
    public String publicIp() {
        return publicIp;
    }

    /**
     * <p>
     * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * </p>
     * 
     * @return The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
     * @see GatewayType
     */
    public String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bgpAsn() == null) ? 0 : bgpAsn().hashCode());
        hashCode = 31 * hashCode + ((publicIp() == null) ? 0 : publicIp().hashCode());
        hashCode = 31 * hashCode + ((type() == null) ? 0 : type().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest) obj;
        if (other.bgpAsn() == null ^ this.bgpAsn() == null) {
            return false;
        }
        if (other.bgpAsn() != null && !other.bgpAsn().equals(this.bgpAsn())) {
            return false;
        }
        if (other.publicIp() == null ^ this.publicIp() == null) {
            return false;
        }
        if (other.publicIp() != null && !other.publicIp().equals(this.publicIp())) {
            return false;
        }
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bgpAsn() != null) {
            sb.append("BgpAsn: ").append(bgpAsn()).append(",");
        }
        if (publicIp() != null) {
            sb.append("PublicIp: ").append(publicIp()).append(",");
        }
        if (type() != null) {
            sb.append("Type: ").append(type()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CreateCustomerGatewayRequest> {
        /**
         * <p>
         * For devices that support BGP, the customer gateway's BGP ASN.
         * </p>
         * <p>
         * Default: 65000
         * </p>
         * 
         * @param bgpAsn
         *        For devices that support BGP, the customer gateway's BGP ASN.</p>
         *        <p>
         *        Default: 65000
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bgpAsn(Integer bgpAsn);

        /**
         * <p>
         * The Internet-routable IP address for the customer gateway's outside interface. The address must be static.
         * </p>
         * 
         * @param publicIp
         *        The Internet-routable IP address for the customer gateway's outside interface. The address must be
         *        static.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicIp(String publicIp);

        /**
         * <p>
         * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * </p>
         * 
         * @param type
         *        The type of VPN connection that this customer gateway supports (<code>ipsec.1</code>).
         * @see GatewayType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see GatewayType
         */
        Builder type(GatewayType type);
    }

    private static final class BuilderImpl implements Builder {
        private Integer bgpAsn;

        private String publicIp;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCustomerGatewayRequest model) {
            setBgpAsn(model.bgpAsn);
            setPublicIp(model.publicIp);
            setType(model.type);
        }

        public final Integer getBgpAsn() {
            return bgpAsn;
        }

        @Override
        public final Builder bgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
            return this;
        }

        public final void setBgpAsn(Integer bgpAsn) {
            this.bgpAsn = bgpAsn;
        }

        public final String getPublicIp() {
            return publicIp;
        }

        @Override
        public final Builder publicIp(String publicIp) {
            this.publicIp = publicIp;
            return this;
        }

        public final void setPublicIp(String publicIp) {
            this.publicIp = publicIp;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(GatewayType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(GatewayType type) {
            this.type(type.toString());
        }

        @Override
        public CreateCustomerGatewayRequest build() {
            return new CreateCustomerGatewayRequest(this);
        }
    }
}
