/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CopySnapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CopySnapshotRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CopySnapshotRequest.Builder, CopySnapshotRequest> {
    private final String description;

    private final String destinationRegion;

    private final Boolean encrypted;

    private final String kmsKeyId;

    private final String presignedUrl;

    private final String sourceRegion;

    private final String sourceSnapshotId;

    private CopySnapshotRequest(BuilderImpl builder) {
        this.description = builder.description;
        this.destinationRegion = builder.destinationRegion;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.presignedUrl = builder.presignedUrl;
        this.sourceRegion = builder.sourceRegion;
        this.sourceSnapshotId = builder.sourceSnapshotId;
    }

    /**
     * <p>
     * A description for the EBS snapshot.
     * </p>
     * 
     * @return A description for the EBS snapshot.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The destination region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This
     * parameter is only valid for specifying the destination region in a <code>PresignedUrl</code> parameter, where it
     * is required.
     * </p>
     * <note>
     * <p>
     * <code>CopySnapshot</code> sends the snapshot copy to the regional endpoint that you send the HTTP request to,
     * such as <code>ec2.us-east-1.amazonaws.com</code> (in the AWS CLI, this is specified with the
     * <code>--region</code> parameter or the default region in your AWS configuration file).
     * </p>
     * </note>
     * 
     * @return The destination region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation.
     *         This parameter is only valid for specifying the destination region in a <code>PresignedUrl</code>
     *         parameter, where it is required.</p> <note>
     *         <p>
     *         <code>CopySnapshot</code> sends the snapshot copy to the regional endpoint that you send the HTTP request
     *         to, such as <code>ec2.us-east-1.amazonaws.com</code> (in the AWS CLI, this is specified with the
     *         <code>--region</code> parameter or the default region in your AWS configuration file).
     *         </p>
     */
    public String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * Specifies whether the destination snapshot should be encrypted. You can encrypt a copy of an unencrypted snapshot
     * using this flag, but you cannot use it to create an unencrypted copy from an encrypted snapshot. Your default CMK
     * for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified with
     * <code>KmsKeyId</code>. For more information, see <a
     * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
     * <i>Amazon Elastic Compute Cloud User Guide</i>.
     * </p>
     * 
     * @return Specifies whether the destination snapshot should be encrypted. You can encrypt a copy of an unencrypted
     *         snapshot using this flag, but you cannot use it to create an unencrypted copy from an encrypted snapshot.
     *         Your default CMK for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is
     *         specified with <code>KmsKeyId</code>. For more information, see <a
     *         href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in
     *         the <i>Amazon Elastic Compute Cloud User Guide</i>.
     */
    public Boolean encrypted() {
        return encrypted;
    }

    /**
     * <p>
     * The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when creating the snapshot copy. This
     * parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the default
     * CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the region of the CMK,
     * the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For example,
     * arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The specified
     * CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code> is specified, the
     * <code>Encrypted</code> flag must also be set.
     * </p>
     * 
     * @return The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when creating the snapshot copy. This
     *         parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the
     *         default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the
     *         region of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK
     *         ID. For example,
     *         arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The
     *         specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code>
     *         is specified, the <code>Encrypted</code> flag must also be set.
     */
    public String kmsKeyId() {
        return kmsKeyId;
    }

    /**
     * <p>
     * The pre-signed URL that facilitates copying an encrypted snapshot. This parameter is only required when copying
     * an encrypted snapshot with the Amazon EC2 Query API; it is available as an optional parameter in all other cases.
     * The <code>PresignedUrl</code> should use the snapshot source endpoint, the <code>CopySnapshot</code> action, and
     * include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>, and <code>DestinationRegion</code>
     * parameters. The <code>PresignedUrl</code> must be signed using AWS Signature Version 4. Because EBS snapshots are
     * stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a
     * href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests by
     * Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage Service API Reference</i>.
     * An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to fail asynchronously,
     * and the snapshot will move to an <code>error</code> state.
     * </p>
     * 
     * @return The pre-signed URL that facilitates copying an encrypted snapshot. This parameter is only required when
     *         copying an encrypted snapshot with the Amazon EC2 Query API; it is available as an optional parameter in
     *         all other cases. The <code>PresignedUrl</code> should use the snapshot source endpoint, the
     *         <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>,
     *         <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The
     *         <code>PresignedUrl</code> must be signed using AWS Signature Version 4. Because EBS snapshots are stored
     *         in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in <a
     *         href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating
     *         Requests by Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage Service
     *         API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy
     *         operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.
     */
    public String presignedUrl() {
        return presignedUrl;
    }

    /**
     * <p>
     * The ID of the region that contains the snapshot to be copied.
     * </p>
     * 
     * @return The ID of the region that contains the snapshot to be copied.
     */
    public String sourceRegion() {
        return sourceRegion;
    }

    /**
     * <p>
     * The ID of the EBS snapshot to copy.
     * </p>
     * 
     * @return The ID of the EBS snapshot to copy.
     */
    public String sourceSnapshotId() {
        return sourceSnapshotId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((description() == null) ? 0 : description().hashCode());
        hashCode = 31 * hashCode + ((destinationRegion() == null) ? 0 : destinationRegion().hashCode());
        hashCode = 31 * hashCode + ((encrypted() == null) ? 0 : encrypted().hashCode());
        hashCode = 31 * hashCode + ((kmsKeyId() == null) ? 0 : kmsKeyId().hashCode());
        hashCode = 31 * hashCode + ((presignedUrl() == null) ? 0 : presignedUrl().hashCode());
        hashCode = 31 * hashCode + ((sourceRegion() == null) ? 0 : sourceRegion().hashCode());
        hashCode = 31 * hashCode + ((sourceSnapshotId() == null) ? 0 : sourceSnapshotId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopySnapshotRequest)) {
            return false;
        }
        CopySnapshotRequest other = (CopySnapshotRequest) obj;
        if (other.description() == null ^ this.description() == null) {
            return false;
        }
        if (other.description() != null && !other.description().equals(this.description())) {
            return false;
        }
        if (other.destinationRegion() == null ^ this.destinationRegion() == null) {
            return false;
        }
        if (other.destinationRegion() != null && !other.destinationRegion().equals(this.destinationRegion())) {
            return false;
        }
        if (other.encrypted() == null ^ this.encrypted() == null) {
            return false;
        }
        if (other.encrypted() != null && !other.encrypted().equals(this.encrypted())) {
            return false;
        }
        if (other.kmsKeyId() == null ^ this.kmsKeyId() == null) {
            return false;
        }
        if (other.kmsKeyId() != null && !other.kmsKeyId().equals(this.kmsKeyId())) {
            return false;
        }
        if (other.presignedUrl() == null ^ this.presignedUrl() == null) {
            return false;
        }
        if (other.presignedUrl() != null && !other.presignedUrl().equals(this.presignedUrl())) {
            return false;
        }
        if (other.sourceRegion() == null ^ this.sourceRegion() == null) {
            return false;
        }
        if (other.sourceRegion() != null && !other.sourceRegion().equals(this.sourceRegion())) {
            return false;
        }
        if (other.sourceSnapshotId() == null ^ this.sourceSnapshotId() == null) {
            return false;
        }
        if (other.sourceSnapshotId() != null && !other.sourceSnapshotId().equals(this.sourceSnapshotId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (description() != null) {
            sb.append("Description: ").append(description()).append(",");
        }
        if (destinationRegion() != null) {
            sb.append("DestinationRegion: ").append(destinationRegion()).append(",");
        }
        if (encrypted() != null) {
            sb.append("Encrypted: ").append(encrypted()).append(",");
        }
        if (kmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(kmsKeyId()).append(",");
        }
        if (presignedUrl() != null) {
            sb.append("PresignedUrl: ").append(presignedUrl()).append(",");
        }
        if (sourceRegion() != null) {
            sb.append("SourceRegion: ").append(sourceRegion()).append(",");
        }
        if (sourceSnapshotId() != null) {
            sb.append("SourceSnapshotId: ").append(sourceSnapshotId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CopySnapshotRequest> {
        /**
         * <p>
         * A description for the EBS snapshot.
         * </p>
         * 
         * @param description
         *        A description for the EBS snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The destination region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation. This
         * parameter is only valid for specifying the destination region in a <code>PresignedUrl</code> parameter, where
         * it is required.
         * </p>
         * <note>
         * <p>
         * <code>CopySnapshot</code> sends the snapshot copy to the regional endpoint that you send the HTTP request to,
         * such as <code>ec2.us-east-1.amazonaws.com</code> (in the AWS CLI, this is specified with the
         * <code>--region</code> parameter or the default region in your AWS configuration file).
         * </p>
         * </note>
         * 
         * @param destinationRegion
         *        The destination region to use in the <code>PresignedUrl</code> parameter of a snapshot copy operation.
         *        This parameter is only valid for specifying the destination region in a <code>PresignedUrl</code>
         *        parameter, where it is required.</p> <note>
         *        <p>
         *        <code>CopySnapshot</code> sends the snapshot copy to the regional endpoint that you send the HTTP
         *        request to, such as <code>ec2.us-east-1.amazonaws.com</code> (in the AWS CLI, this is specified with
         *        the <code>--region</code> parameter or the default region in your AWS configuration file).
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * Specifies whether the destination snapshot should be encrypted. You can encrypt a copy of an unencrypted
         * snapshot using this flag, but you cannot use it to create an unencrypted copy from an encrypted snapshot.
         * Your default CMK for EBS is used unless a non-default AWS Key Management Service (AWS KMS) CMK is specified
         * with <code>KmsKeyId</code>. For more information, see <a
         * href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a> in the
         * <i>Amazon Elastic Compute Cloud User Guide</i>.
         * </p>
         * 
         * @param encrypted
         *        Specifies whether the destination snapshot should be encrypted. You can encrypt a copy of an
         *        unencrypted snapshot using this flag, but you cannot use it to create an unencrypted copy from an
         *        encrypted snapshot. Your default CMK for EBS is used unless a non-default AWS Key Management Service
         *        (AWS KMS) CMK is specified with <code>KmsKeyId</code>. For more information, see <a
         *        href="http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html">Amazon EBS Encryption</a>
         *        in the <i>Amazon Elastic Compute Cloud User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encrypted(Boolean encrypted);

        /**
         * <p>
         * The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when creating the snapshot copy. This
         * parameter is only required if you want to use a non-default CMK; if this parameter is not specified, the
         * default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace, followed by the region
         * of the CMK, the AWS account ID of the CMK owner, the <code>key</code> namespace, and then the CMK ID. For
         * example, arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>.
         * The specified CMK must exist in the region that the snapshot is being copied to. If a <code>KmsKeyId</code>
         * is specified, the <code>Encrypted</code> flag must also be set.
         * </p>
         * 
         * @param kmsKeyId
         *        The full ARN of the AWS Key Management Service (AWS KMS) CMK to use when creating the snapshot copy.
         *        This parameter is only required if you want to use a non-default CMK; if this parameter is not
         *        specified, the default CMK for EBS is used. The ARN contains the <code>arn:aws:kms</code> namespace,
         *        followed by the region of the CMK, the AWS account ID of the CMK owner, the <code>key</code>
         *        namespace, and then the CMK ID. For example,
         *        arn:aws:kms:<i>us-east-1</i>:<i>012345678910</i>:key/<i>abcd1234-a123-456a-a12b-a123b4cd56ef</i>. The
         *        specified CMK must exist in the region that the snapshot is being copied to. If a
         *        <code>KmsKeyId</code> is specified, the <code>Encrypted</code> flag must also be set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyId(String kmsKeyId);

        /**
         * <p>
         * The pre-signed URL that facilitates copying an encrypted snapshot. This parameter is only required when
         * copying an encrypted snapshot with the Amazon EC2 Query API; it is available as an optional parameter in all
         * other cases. The <code>PresignedUrl</code> should use the snapshot source endpoint, the
         * <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>, <code>SourceSnapshotId</code>,
         * and <code>DestinationRegion</code> parameters. The <code>PresignedUrl</code> must be signed using AWS
         * Signature Version 4. Because EBS snapshots are stored in Amazon S3, the signing algorithm for this parameter
         * uses the same logic that is described in <a
         * href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating Requests by
         * Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage Service API
         * Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the copy operation to
         * fail asynchronously, and the snapshot will move to an <code>error</code> state.
         * </p>
         * 
         * @param presignedUrl
         *        The pre-signed URL that facilitates copying an encrypted snapshot. This parameter is only required
         *        when copying an encrypted snapshot with the Amazon EC2 Query API; it is available as an optional
         *        parameter in all other cases. The <code>PresignedUrl</code> should use the snapshot source endpoint,
         *        the <code>CopySnapshot</code> action, and include the <code>SourceRegion</code>,
         *        <code>SourceSnapshotId</code>, and <code>DestinationRegion</code> parameters. The
         *        <code>PresignedUrl</code> must be signed using AWS Signature Version 4. Because EBS snapshots are
         *        stored in Amazon S3, the signing algorithm for this parameter uses the same logic that is described in
         *        <a href="http://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html">Authenticating
         *        Requests by Using Query Parameters (AWS Signature Version 4)</a> in the <i>Amazon Simple Storage
         *        Service API Reference</i>. An invalid or improperly signed <code>PresignedUrl</code> will cause the
         *        copy operation to fail asynchronously, and the snapshot will move to an <code>error</code> state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder presignedUrl(String presignedUrl);

        /**
         * <p>
         * The ID of the region that contains the snapshot to be copied.
         * </p>
         * 
         * @param sourceRegion
         *        The ID of the region that contains the snapshot to be copied.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceRegion(String sourceRegion);

        /**
         * <p>
         * The ID of the EBS snapshot to copy.
         * </p>
         * 
         * @param sourceSnapshotId
         *        The ID of the EBS snapshot to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceSnapshotId(String sourceSnapshotId);
    }

    private static final class BuilderImpl implements Builder {
        private String description;

        private String destinationRegion;

        private Boolean encrypted;

        private String kmsKeyId;

        private String presignedUrl;

        private String sourceRegion;

        private String sourceSnapshotId;

        private BuilderImpl() {
        }

        private BuilderImpl(CopySnapshotRequest model) {
            setDescription(model.description);
            setDestinationRegion(model.destinationRegion);
            setEncrypted(model.encrypted);
            setKmsKeyId(model.kmsKeyId);
            setPresignedUrl(model.presignedUrl);
            setSourceRegion(model.sourceRegion);
            setSourceSnapshotId(model.sourceSnapshotId);
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Boolean getEncrypted() {
            return encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final String getPresignedUrl() {
            return presignedUrl;
        }

        @Override
        public final Builder presignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
            return this;
        }

        public final void setPresignedUrl(String presignedUrl) {
            this.presignedUrl = presignedUrl;
        }

        public final String getSourceRegion() {
            return sourceRegion;
        }

        @Override
        public final Builder sourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
            return this;
        }

        public final void setSourceRegion(String sourceRegion) {
            this.sourceRegion = sourceRegion;
        }

        public final String getSourceSnapshotId() {
            return sourceSnapshotId;
        }

        @Override
        public final Builder sourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
            return this;
        }

        public final void setSourceSnapshotId(String sourceSnapshotId) {
            this.sourceSnapshotId = sourceSnapshotId;
        }

        @Override
        public CopySnapshotRequest build() {
            return new CopySnapshotRequest(this);
        }
    }
}
