/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the client-specific data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClientData implements ToCopyableBuilder<ClientData.Builder, ClientData> {
    private final String comment;

    private final Instant uploadEnd;

    private final Double uploadSize;

    private final Instant uploadStart;

    private ClientData(BuilderImpl builder) {
        this.comment = builder.comment;
        this.uploadEnd = builder.uploadEnd;
        this.uploadSize = builder.uploadSize;
        this.uploadStart = builder.uploadStart;
    }

    /**
     * <p>
     * A user-defined comment about the disk upload.
     * </p>
     * 
     * @return A user-defined comment about the disk upload.
     */
    public String comment() {
        return comment;
    }

    /**
     * <p>
     * The time that the disk upload ends.
     * </p>
     * 
     * @return The time that the disk upload ends.
     */
    public Instant uploadEnd() {
        return uploadEnd;
    }

    /**
     * <p>
     * The size of the uploaded disk image, in GiB.
     * </p>
     * 
     * @return The size of the uploaded disk image, in GiB.
     */
    public Double uploadSize() {
        return uploadSize;
    }

    /**
     * <p>
     * The time that the disk upload starts.
     * </p>
     * 
     * @return The time that the disk upload starts.
     */
    public Instant uploadStart() {
        return uploadStart;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((comment() == null) ? 0 : comment().hashCode());
        hashCode = 31 * hashCode + ((uploadEnd() == null) ? 0 : uploadEnd().hashCode());
        hashCode = 31 * hashCode + ((uploadSize() == null) ? 0 : uploadSize().hashCode());
        hashCode = 31 * hashCode + ((uploadStart() == null) ? 0 : uploadStart().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClientData)) {
            return false;
        }
        ClientData other = (ClientData) obj;
        if (other.comment() == null ^ this.comment() == null) {
            return false;
        }
        if (other.comment() != null && !other.comment().equals(this.comment())) {
            return false;
        }
        if (other.uploadEnd() == null ^ this.uploadEnd() == null) {
            return false;
        }
        if (other.uploadEnd() != null && !other.uploadEnd().equals(this.uploadEnd())) {
            return false;
        }
        if (other.uploadSize() == null ^ this.uploadSize() == null) {
            return false;
        }
        if (other.uploadSize() != null && !other.uploadSize().equals(this.uploadSize())) {
            return false;
        }
        if (other.uploadStart() == null ^ this.uploadStart() == null) {
            return false;
        }
        if (other.uploadStart() != null && !other.uploadStart().equals(this.uploadStart())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (comment() != null) {
            sb.append("Comment: ").append(comment()).append(",");
        }
        if (uploadEnd() != null) {
            sb.append("UploadEnd: ").append(uploadEnd()).append(",");
        }
        if (uploadSize() != null) {
            sb.append("UploadSize: ").append(uploadSize()).append(",");
        }
        if (uploadStart() != null) {
            sb.append("UploadStart: ").append(uploadStart()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ClientData> {
        /**
         * <p>
         * A user-defined comment about the disk upload.
         * </p>
         * 
         * @param comment
         *        A user-defined comment about the disk upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The time that the disk upload ends.
         * </p>
         * 
         * @param uploadEnd
         *        The time that the disk upload ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadEnd(Instant uploadEnd);

        /**
         * <p>
         * The size of the uploaded disk image, in GiB.
         * </p>
         * 
         * @param uploadSize
         *        The size of the uploaded disk image, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadSize(Double uploadSize);

        /**
         * <p>
         * The time that the disk upload starts.
         * </p>
         * 
         * @param uploadStart
         *        The time that the disk upload starts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadStart(Instant uploadStart);
    }

    private static final class BuilderImpl implements Builder {
        private String comment;

        private Instant uploadEnd;

        private Double uploadSize;

        private Instant uploadStart;

        private BuilderImpl() {
        }

        private BuilderImpl(ClientData model) {
            setComment(model.comment);
            setUploadEnd(model.uploadEnd);
            setUploadSize(model.uploadSize);
            setUploadStart(model.uploadStart);
        }

        public final String getComment() {
            return comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        public final Instant getUploadEnd() {
            return uploadEnd;
        }

        @Override
        public final Builder uploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
            return this;
        }

        public final void setUploadEnd(Instant uploadEnd) {
            this.uploadEnd = uploadEnd;
        }

        public final Double getUploadSize() {
            return uploadSize;
        }

        @Override
        public final Builder uploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
            return this;
        }

        public final void setUploadSize(Double uploadSize) {
            this.uploadSize = uploadSize;
        }

        public final Instant getUploadStart() {
            return uploadStart;
        }

        @Override
        public final Builder uploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
            return this;
        }

        public final void setUploadStart(Instant uploadStart) {
            this.uploadStart = uploadStart;
        }

        @Override
        public ClientData build() {
            return new ClientData(this);
        }
    }
}
