/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the ClassicLink DNS support status of a VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class ClassicLinkDnsSupport implements ToCopyableBuilder<ClassicLinkDnsSupport.Builder, ClassicLinkDnsSupport> {
    private final Boolean classicLinkDnsSupported;

    private final String vpcId;

    private ClassicLinkDnsSupport(BuilderImpl builder) {
        this.classicLinkDnsSupported = builder.classicLinkDnsSupported;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * Indicates whether ClassicLink DNS support is enabled for the VPC.
     * </p>
     * 
     * @return Indicates whether ClassicLink DNS support is enabled for the VPC.
     */
    public Boolean classicLinkDnsSupported() {
        return classicLinkDnsSupported;
    }

    /**
     * <p>
     * The ID of the VPC.
     * </p>
     * 
     * @return The ID of the VPC.
     */
    public String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((classicLinkDnsSupported() == null) ? 0 : classicLinkDnsSupported().hashCode());
        hashCode = 31 * hashCode + ((vpcId() == null) ? 0 : vpcId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClassicLinkDnsSupport)) {
            return false;
        }
        ClassicLinkDnsSupport other = (ClassicLinkDnsSupport) obj;
        if (other.classicLinkDnsSupported() == null ^ this.classicLinkDnsSupported() == null) {
            return false;
        }
        if (other.classicLinkDnsSupported() != null && !other.classicLinkDnsSupported().equals(this.classicLinkDnsSupported())) {
            return false;
        }
        if (other.vpcId() == null ^ this.vpcId() == null) {
            return false;
        }
        if (other.vpcId() != null && !other.vpcId().equals(this.vpcId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (classicLinkDnsSupported() != null) {
            sb.append("ClassicLinkDnsSupported: ").append(classicLinkDnsSupported()).append(",");
        }
        if (vpcId() != null) {
            sb.append("VpcId: ").append(vpcId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, ClassicLinkDnsSupport> {
        /**
         * <p>
         * Indicates whether ClassicLink DNS support is enabled for the VPC.
         * </p>
         * 
         * @param classicLinkDnsSupported
         *        Indicates whether ClassicLink DNS support is enabled for the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder classicLinkDnsSupported(Boolean classicLinkDnsSupported);

        /**
         * <p>
         * The ID of the VPC.
         * </p>
         * 
         * @param vpcId
         *        The ID of the VPC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    private static final class BuilderImpl implements Builder {
        private Boolean classicLinkDnsSupported;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(ClassicLinkDnsSupport model) {
            setClassicLinkDnsSupported(model.classicLinkDnsSupported);
            setVpcId(model.vpcId);
        }

        public final Boolean getClassicLinkDnsSupported() {
            return classicLinkDnsSupported;
        }

        @Override
        public final Builder classicLinkDnsSupported(Boolean classicLinkDnsSupported) {
            this.classicLinkDnsSupported = classicLinkDnsSupported;
            return this;
        }

        public final void setClassicLinkDnsSupported(Boolean classicLinkDnsSupported) {
            this.classicLinkDnsSupported = classicLinkDnsSupported;
        }

        public final String getVpcId() {
            return vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public ClassicLinkDnsSupport build() {
            return new ClassicLinkDnsSupport(this);
        }
    }
}
