/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for CancelBundleTask.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class CancelBundleTaskRequest extends AmazonWebServiceRequest implements
        ToCopyableBuilder<CancelBundleTaskRequest.Builder, CancelBundleTaskRequest> {
    private final String bundleId;

    private CancelBundleTaskRequest(BuilderImpl builder) {
        this.bundleId = builder.bundleId;
    }

    /**
     * <p>
     * The ID of the bundle task.
     * </p>
     * 
     * @return The ID of the bundle task.
     */
    public String bundleId() {
        return bundleId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((bundleId() == null) ? 0 : bundleId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelBundleTaskRequest)) {
            return false;
        }
        CancelBundleTaskRequest other = (CancelBundleTaskRequest) obj;
        if (other.bundleId() == null ^ this.bundleId() == null) {
            return false;
        }
        if (other.bundleId() != null && !other.bundleId().equals(this.bundleId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (bundleId() != null) {
            sb.append("BundleId: ").append(bundleId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, CancelBundleTaskRequest> {
        /**
         * <p>
         * The ID of the bundle task.
         * </p>
         * 
         * @param bundleId
         *        The ID of the bundle task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder bundleId(String bundleId);
    }

    private static final class BuilderImpl implements Builder {
        private String bundleId;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelBundleTaskRequest model) {
            setBundleId(model.bundleId);
        }

        public final String getBundleId() {
            return bundleId;
        }

        @Override
        public final Builder bundleId(String bundleId) {
            this.bundleId = bundleId;
            return this;
        }

        public final void setBundleId(String bundleId) {
            this.bundleId = bundleId;
        }

        @Override
        public CancelBundleTaskRequest build() {
            return new CancelBundleTaskRequest(this);
        }
    }
}
