/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The capacity information for instances launched onto the Dedicated Host.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AvailableCapacity implements ToCopyableBuilder<AvailableCapacity.Builder, AvailableCapacity> {
    private final List<InstanceCapacity> availableInstanceCapacity;

    private final Integer availableVCpus;

    private AvailableCapacity(BuilderImpl builder) {
        this.availableInstanceCapacity = builder.availableInstanceCapacity;
        this.availableVCpus = builder.availableVCpus;
    }

    /**
     * <p>
     * The total number of instances that the Dedicated Host supports.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The total number of instances that the Dedicated Host supports.
     */
    public List<InstanceCapacity> availableInstanceCapacity() {
        return availableInstanceCapacity;
    }

    /**
     * <p>
     * The number of vCPUs available on the Dedicated Host.
     * </p>
     * 
     * @return The number of vCPUs available on the Dedicated Host.
     */
    public Integer availableVCpus() {
        return availableVCpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((availableInstanceCapacity() == null) ? 0 : availableInstanceCapacity().hashCode());
        hashCode = 31 * hashCode + ((availableVCpus() == null) ? 0 : availableVCpus().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableCapacity)) {
            return false;
        }
        AvailableCapacity other = (AvailableCapacity) obj;
        if (other.availableInstanceCapacity() == null ^ this.availableInstanceCapacity() == null) {
            return false;
        }
        if (other.availableInstanceCapacity() != null
                && !other.availableInstanceCapacity().equals(this.availableInstanceCapacity())) {
            return false;
        }
        if (other.availableVCpus() == null ^ this.availableVCpus() == null) {
            return false;
        }
        if (other.availableVCpus() != null && !other.availableVCpus().equals(this.availableVCpus())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (availableInstanceCapacity() != null) {
            sb.append("AvailableInstanceCapacity: ").append(availableInstanceCapacity()).append(",");
        }
        if (availableVCpus() != null) {
            sb.append("AvailableVCpus: ").append(availableVCpus()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AvailableCapacity> {
        /**
         * <p>
         * The total number of instances that the Dedicated Host supports.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The total number of instances that the Dedicated Host supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity);

        /**
         * <p>
         * The total number of instances that the Dedicated Host supports.
         * </p>
         * 
         * @param availableInstanceCapacity
         *        The total number of instances that the Dedicated Host supports.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity);

        /**
         * <p>
         * The number of vCPUs available on the Dedicated Host.
         * </p>
         * 
         * @param availableVCpus
         *        The number of vCPUs available on the Dedicated Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableVCpus(Integer availableVCpus);
    }

    private static final class BuilderImpl implements Builder {
        private List<InstanceCapacity> availableInstanceCapacity;

        private Integer availableVCpus;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailableCapacity model) {
            setAvailableInstanceCapacity(model.availableInstanceCapacity);
            setAvailableVCpus(model.availableVCpus);
        }

        public final Collection<InstanceCapacity> getAvailableInstanceCapacity() {
            return availableInstanceCapacity;
        }

        @Override
        public final Builder availableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder availableInstanceCapacity(InstanceCapacity... availableInstanceCapacity) {
            availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
            return this;
        }

        public final void setAvailableInstanceCapacity(Collection<InstanceCapacity> availableInstanceCapacity) {
            this.availableInstanceCapacity = AvailableInstanceCapacityListCopier.copy(availableInstanceCapacity);
        }

        @SafeVarargs
        public final void setAvailableInstanceCapacity(InstanceCapacity... availableInstanceCapacity) {
            availableInstanceCapacity(Arrays.asList(availableInstanceCapacity));
        }

        public final Integer getAvailableVCpus() {
            return availableVCpus;
        }

        @Override
        public final Builder availableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
            return this;
        }

        public final void setAvailableVCpus(Integer availableVCpus) {
            this.availableVCpus = availableVCpus;
        }

        @Override
        public AvailableCapacity build() {
            return new AvailableCapacity(this);
        }
    }
}
