/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a message about an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AvailabilityZoneMessage implements ToCopyableBuilder<AvailabilityZoneMessage.Builder, AvailabilityZoneMessage> {
    private final String message;

    private AvailabilityZoneMessage(BuilderImpl builder) {
        this.message = builder.message;
    }

    /**
     * <p>
     * The message about the Availability Zone.
     * </p>
     * 
     * @return The message about the Availability Zone.
     */
    public String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((message() == null) ? 0 : message().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZoneMessage)) {
            return false;
        }
        AvailabilityZoneMessage other = (AvailabilityZoneMessage) obj;
        if (other.message() == null ^ this.message() == null) {
            return false;
        }
        if (other.message() != null && !other.message().equals(this.message())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (message() != null) {
            sb.append("Message: ").append(message()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AvailabilityZoneMessage> {
        /**
         * <p>
         * The message about the Availability Zone.
         * </p>
         * 
         * @param message
         *        The message about the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    private static final class BuilderImpl implements Builder {
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZoneMessage model) {
            setMessage(model.message);
        }

        public final String getMessage() {
            return message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public AvailabilityZoneMessage build() {
            return new AvailabilityZoneMessage(this);
        }
    }
}
