/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Generated;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an Availability Zone.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AvailabilityZone implements ToCopyableBuilder<AvailabilityZone.Builder, AvailabilityZone> {
    private final String state;

    private final List<AvailabilityZoneMessage> messages;

    private final String regionName;

    private final String zoneName;

    private AvailabilityZone(BuilderImpl builder) {
        this.state = builder.state;
        this.messages = builder.messages;
        this.regionName = builder.regionName;
        this.zoneName = builder.zoneName;
    }

    /**
     * <p>
     * The state of the Availability Zone.
     * </p>
     * 
     * @return The state of the Availability Zone.
     * @see AvailabilityZoneState
     */
    public String state() {
        return state;
    }

    /**
     * <p>
     * Any messages about the Availability Zone.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Any messages about the Availability Zone.
     */
    public List<AvailabilityZoneMessage> messages() {
        return messages;
    }

    /**
     * <p>
     * The name of the region.
     * </p>
     * 
     * @return The name of the region.
     */
    public String regionName() {
        return regionName;
    }

    /**
     * <p>
     * The name of the Availability Zone.
     * </p>
     * 
     * @return The name of the Availability Zone.
     */
    public String zoneName() {
        return zoneName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((state() == null) ? 0 : state().hashCode());
        hashCode = 31 * hashCode + ((messages() == null) ? 0 : messages().hashCode());
        hashCode = 31 * hashCode + ((regionName() == null) ? 0 : regionName().hashCode());
        hashCode = 31 * hashCode + ((zoneName() == null) ? 0 : zoneName().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailabilityZone)) {
            return false;
        }
        AvailabilityZone other = (AvailabilityZone) obj;
        if (other.state() == null ^ this.state() == null) {
            return false;
        }
        if (other.state() != null && !other.state().equals(this.state())) {
            return false;
        }
        if (other.messages() == null ^ this.messages() == null) {
            return false;
        }
        if (other.messages() != null && !other.messages().equals(this.messages())) {
            return false;
        }
        if (other.regionName() == null ^ this.regionName() == null) {
            return false;
        }
        if (other.regionName() != null && !other.regionName().equals(this.regionName())) {
            return false;
        }
        if (other.zoneName() == null ^ this.zoneName() == null) {
            return false;
        }
        if (other.zoneName() != null && !other.zoneName().equals(this.zoneName())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (state() != null) {
            sb.append("State: ").append(state()).append(",");
        }
        if (messages() != null) {
            sb.append("Messages: ").append(messages()).append(",");
        }
        if (regionName() != null) {
            sb.append("RegionName: ").append(regionName()).append(",");
        }
        if (zoneName() != null) {
            sb.append("ZoneName: ").append(zoneName()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AvailabilityZone> {
        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the Availability Zone.
         * </p>
         * 
         * @param state
         *        The state of the Availability Zone.
         * @see AvailabilityZoneState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AvailabilityZoneState
         */
        Builder state(AvailabilityZoneState state);

        /**
         * <p>
         * Any messages about the Availability Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(Collection<AvailabilityZoneMessage> messages);

        /**
         * <p>
         * Any messages about the Availability Zone.
         * </p>
         * 
         * @param messages
         *        Any messages about the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messages(AvailabilityZoneMessage... messages);

        /**
         * <p>
         * The name of the region.
         * </p>
         * 
         * @param regionName
         *        The name of the region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionName(String regionName);

        /**
         * <p>
         * The name of the Availability Zone.
         * </p>
         * 
         * @param zoneName
         *        The name of the Availability Zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder zoneName(String zoneName);
    }

    private static final class BuilderImpl implements Builder {
        private String state;

        private List<AvailabilityZoneMessage> messages;

        private String regionName;

        private String zoneName;

        private BuilderImpl() {
        }

        private BuilderImpl(AvailabilityZone model) {
            setState(model.state);
            setMessages(model.messages);
            setRegionName(model.regionName);
            setZoneName(model.zoneName);
        }

        public final String getState() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(AvailabilityZoneState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final void setState(AvailabilityZoneState state) {
            this.state(state.toString());
        }

        public final Collection<AvailabilityZoneMessage> getMessages() {
            return messages;
        }

        @Override
        public final Builder messages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(AvailabilityZoneMessage... messages) {
            messages(Arrays.asList(messages));
            return this;
        }

        public final void setMessages(Collection<AvailabilityZoneMessage> messages) {
            this.messages = AvailabilityZoneMessageListCopier.copy(messages);
        }

        @SafeVarargs
        public final void setMessages(AvailabilityZoneMessage... messages) {
            messages(Arrays.asList(messages));
        }

        public final String getRegionName() {
            return regionName;
        }

        @Override
        public final Builder regionName(String regionName) {
            this.regionName = regionName;
            return this;
        }

        public final void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public final String getZoneName() {
            return zoneName;
        }

        @Override
        public final Builder zoneName(String zoneName) {
            this.zoneName = zoneName;
            return this;
        }

        public final void setZoneName(String zoneName) {
            this.zoneName = zoneName;
        }

        @Override
        public AvailabilityZone build() {
            return new AvailabilityZone(this);
        }
    }
}
