/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AssociateRouteTable.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AssociateRouteTableResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AssociateRouteTableResponse.Builder, AssociateRouteTableResponse> {
    private final String associationId;

    private AssociateRouteTableResponse(BuilderImpl builder) {
        this.associationId = builder.associationId;
    }

    /**
     * <p>
     * The route table association ID (needed to disassociate the route table).
     * </p>
     * 
     * @return The route table association ID (needed to disassociate the route table).
     */
    public String associationId() {
        return associationId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((associationId() == null) ? 0 : associationId().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateRouteTableResponse)) {
            return false;
        }
        AssociateRouteTableResponse other = (AssociateRouteTableResponse) obj;
        if (other.associationId() == null ^ this.associationId() == null) {
            return false;
        }
        if (other.associationId() != null && !other.associationId().equals(this.associationId())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (associationId() != null) {
            sb.append("AssociationId: ").append(associationId()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AssociateRouteTableResponse> {
        /**
         * <p>
         * The route table association ID (needed to disassociate the route table).
         * </p>
         * 
         * @param associationId
         *        The route table association ID (needed to disassociate the route table).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associationId(String associationId);
    }

    private static final class BuilderImpl implements Builder {
        private String associationId;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateRouteTableResponse model) {
            setAssociationId(model.associationId);
        }

        public final String getAssociationId() {
            return associationId;
        }

        @Override
        public final Builder associationId(String associationId) {
            this.associationId = associationId;
            return this;
        }

        public final void setAssociationId(String associationId) {
            this.associationId = associationId;
        }

        @Override
        public AssociateRouteTableResponse build() {
            return new AssociateRouteTableResponse(this);
        }
    }
}
