/*
 * Copyright 2012-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ec2.model;

import javax.annotation.Generated;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the output of AcceptVpcPeeringConnection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public class AcceptVpcPeeringConnectionResponse extends AmazonWebServiceResult<ResponseMetadata> implements
        ToCopyableBuilder<AcceptVpcPeeringConnectionResponse.Builder, AcceptVpcPeeringConnectionResponse> {
    private final VpcPeeringConnection vpcPeeringConnection;

    private AcceptVpcPeeringConnectionResponse(BuilderImpl builder) {
        this.vpcPeeringConnection = builder.vpcPeeringConnection;
    }

    /**
     * <p>
     * Information about the VPC peering connection.
     * </p>
     * 
     * @return Information about the VPC peering connection.
     */
    public VpcPeeringConnection vpcPeeringConnection() {
        return vpcPeeringConnection;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ((vpcPeeringConnection() == null) ? 0 : vpcPeeringConnection().hashCode());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptVpcPeeringConnectionResponse)) {
            return false;
        }
        AcceptVpcPeeringConnectionResponse other = (AcceptVpcPeeringConnectionResponse) obj;
        if (other.vpcPeeringConnection() == null ^ this.vpcPeeringConnection() == null) {
            return false;
        }
        if (other.vpcPeeringConnection() != null && !other.vpcPeeringConnection().equals(this.vpcPeeringConnection())) {
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (vpcPeeringConnection() != null) {
            sb.append("VpcPeeringConnection: ").append(vpcPeeringConnection()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    public interface Builder extends CopyableBuilder<Builder, AcceptVpcPeeringConnectionResponse> {
        /**
         * <p>
         * Information about the VPC peering connection.
         * </p>
         * 
         * @param vpcPeeringConnection
         *        Information about the VPC peering connection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection);
    }

    private static final class BuilderImpl implements Builder {
        private VpcPeeringConnection vpcPeeringConnection;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptVpcPeeringConnectionResponse model) {
            setVpcPeeringConnection(model.vpcPeeringConnection);
        }

        public final VpcPeeringConnection getVpcPeeringConnection() {
            return vpcPeeringConnection;
        }

        @Override
        public final Builder vpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
            return this;
        }

        public final void setVpcPeeringConnection(VpcPeeringConnection vpcPeeringConnection) {
            this.vpcPeeringConnection = vpcPeeringConnection;
        }

        @Override
        public AcceptVpcPeeringConnectionResponse build() {
            return new AcceptVpcPeeringConnectionResponse(this);
        }
    }
}
