/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeReservedInstancesOfferingsResponse;
import software.amazon.awssdk.services.ec2.model.ReservedInstancesOffering;

public class DescribeReservedInstancesOfferingsPublisher
implements SdkPublisher<DescribeReservedInstancesOfferingsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeReservedInstancesOfferingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeReservedInstancesOfferingsPublisher(Ec2AsyncClient client, DescribeReservedInstancesOfferingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeReservedInstancesOfferingsPublisher(Ec2AsyncClient client, DescribeReservedInstancesOfferingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeReservedInstancesOfferingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeReservedInstancesOfferingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ReservedInstancesOffering> reservedInstancesOfferings() {
        Function<DescribeReservedInstancesOfferingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedInstancesOfferings() != null) {
                return response.reservedInstancesOfferings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeReservedInstancesOfferingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeReservedInstancesOfferingsPublisher resume(DescribeReservedInstancesOfferingsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeReservedInstancesOfferingsPublisher(this.client, (DescribeReservedInstancesOfferingsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeReservedInstancesOfferingsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeReservedInstancesOfferingsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeReservedInstancesOfferingsResponseFetcher
    implements AsyncPageFetcher<DescribeReservedInstancesOfferingsResponse> {
        private DescribeReservedInstancesOfferingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeReservedInstancesOfferingsResponse> nextPage(DescribeReservedInstancesOfferingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedInstancesOfferingsPublisher.this.client.describeReservedInstancesOfferings(DescribeReservedInstancesOfferingsPublisher.this.firstRequest);
            }
            return DescribeReservedInstancesOfferingsPublisher.this.client.describeReservedInstancesOfferings((DescribeReservedInstancesOfferingsRequest)((Object)DescribeReservedInstancesOfferingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

