/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.KeyPairListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeKeyPairsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeKeyPairsResponse> {
    private static final SdkField<List<KeyPairInfo>> KEY_PAIRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeKeyPairsResponse.getter(DescribeKeyPairsResponse::keyPairs)).setter(DescribeKeyPairsResponse.setter(Builder::keyPairs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeySet").unmarshallLocationName("keySet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyPairInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_PAIRS_FIELD));
    private final List<KeyPairInfo> keyPairs;

    private DescribeKeyPairsResponse(BuilderImpl builder) {
        super(builder);
        this.keyPairs = builder.keyPairs;
    }

    public List<KeyPairInfo> keyPairs() {
        return this.keyPairs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.keyPairs());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeKeyPairsResponse)) {
            return false;
        }
        DescribeKeyPairsResponse other = (DescribeKeyPairsResponse)((Object)obj);
        return Objects.equals(this.keyPairs(), other.keyPairs());
    }

    public String toString() {
        return ToString.builder((String)"DescribeKeyPairsResponse").add("KeyPairs", this.keyPairs()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "KeyPairs": {
                return Optional.ofNullable(clazz.cast(this.keyPairs()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeKeyPairsResponse, T> g) {
        return obj -> g.apply((DescribeKeyPairsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<KeyPairInfo> keyPairs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeKeyPairsResponse model) {
            super(model);
            this.keyPairs(model.keyPairs);
        }

        public final Collection<KeyPairInfo.Builder> getKeyPairs() {
            return this.keyPairs != null ? (Collection)this.keyPairs.stream().map(KeyPairInfo::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder keyPairs(Collection<KeyPairInfo> keyPairs) {
            this.keyPairs = KeyPairListCopier.copy(keyPairs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(KeyPairInfo ... keyPairs) {
            this.keyPairs(Arrays.asList(keyPairs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keyPairs(Consumer<KeyPairInfo.Builder> ... keyPairs) {
            this.keyPairs(Stream.of(keyPairs).map(c -> (KeyPairInfo)((KeyPairInfo.Builder)KeyPairInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setKeyPairs(Collection<KeyPairInfo.BuilderImpl> keyPairs) {
            this.keyPairs = KeyPairListCopier.copyFromBuilder(keyPairs);
        }

        @Override
        public DescribeKeyPairsResponse build() {
            return new DescribeKeyPairsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeKeyPairsResponse> {
        public Builder keyPairs(Collection<KeyPairInfo> var1);

        public Builder keyPairs(KeyPairInfo ... var1);

        public Builder keyPairs(Consumer<KeyPairInfo.Builder> ... var1);
    }
}

