/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.DnsEntry;
import software.amazon.awssdk.services.ec2.model.SecurityGroupIdentifier;
import software.amazon.awssdk.services.ec2.model.VpcEndpoint;
import software.amazon.awssdk.services.ec2.transform.DnsEntryUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.SecurityGroupIdentifierUnmarshaller;

public class VpcEndpointUnmarshaller
implements Unmarshaller<VpcEndpoint, StaxUnmarshallerContext> {
    private static final VpcEndpointUnmarshaller INSTANCE = new VpcEndpointUnmarshaller();

    public VpcEndpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpcEndpoint.Builder vpcEndpoint;
        block21: {
            vpcEndpoint = VpcEndpoint.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<String> routeTableIds = null;
            ArrayList<String> subnetIds = null;
            ArrayList<SecurityGroupIdentifier> groups = null;
            ArrayList<String> networkInterfaceIds = null;
            ArrayList<DnsEntry> dnsEntries = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    vpcEndpoint.routeTableIds(routeTableIds);
                    vpcEndpoint.subnetIds(subnetIds);
                    vpcEndpoint.groups(groups);
                    vpcEndpoint.networkInterfaceIds(networkInterfaceIds);
                    vpcEndpoint.dnsEntries(dnsEntries);
                    break block21;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("vpcEndpointId", targetDepth)) {
                        vpcEndpoint.vpcEndpointId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcEndpointType", targetDepth)) {
                        vpcEndpoint.vpcEndpointType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcId", targetDepth)) {
                        vpcEndpoint.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("serviceName", targetDepth)) {
                        vpcEndpoint.serviceName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        vpcEndpoint.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("policyDocument", targetDepth)) {
                        vpcEndpoint.policyDocument(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("routeTableIdSet", targetDepth)) {
                        routeTableIds = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("routeTableIdSet/item", targetDepth)) {
                        routeTableIds.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetIdSet", targetDepth)) {
                        subnetIds = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("subnetIdSet/item", targetDepth)) {
                        subnetIds.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<SecurityGroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(SecurityGroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("privateDnsEnabled", targetDepth)) {
                        vpcEndpoint.privateDnsEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("networkInterfaceIdSet", targetDepth)) {
                        networkInterfaceIds = new ArrayList<String>();
                        continue;
                    }
                    if (context.testExpression("networkInterfaceIdSet/item", targetDepth)) {
                        networkInterfaceIds.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("dnsEntrySet", targetDepth)) {
                        dnsEntries = new ArrayList<DnsEntry>();
                        continue;
                    }
                    if (context.testExpression("dnsEntrySet/item", targetDepth)) {
                        dnsEntries.add(DnsEntryUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("creationTimestamp", targetDepth)) continue;
                    vpcEndpoint.creationTimestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            vpcEndpoint.routeTableIds(routeTableIds);
            vpcEndpoint.subnetIds(subnetIds);
            vpcEndpoint.groups(groups);
            vpcEndpoint.networkInterfaceIds(networkInterfaceIds);
            vpcEndpoint.dnsEntries(dnsEntries);
        }
        return (VpcEndpoint)vpcEndpoint.build();
    }

    public static VpcEndpointUnmarshaller getInstance() {
        return INSTANCE;
    }
}

