/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.GroupIdentifier;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.transform.GroupIdentifierUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.InstanceUnmarshaller;

public class ReservationUnmarshaller
implements Unmarshaller<Reservation, StaxUnmarshallerContext> {
    private static final ReservationUnmarshaller INSTANCE = new ReservationUnmarshaller();

    public Reservation unmarshall(StaxUnmarshallerContext context) throws Exception {
        Reservation.Builder reservation;
        block12: {
            reservation = Reservation.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<GroupIdentifier> groups = null;
            ArrayList<Instance> instances = null;
            ArrayList<String> groupNames = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    reservation.groups(groups);
                    reservation.instances(instances);
                    reservation.groupNames(groupNames);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("groupSet", targetDepth)) {
                        groups = new ArrayList<GroupIdentifier>();
                        continue;
                    }
                    if (context.testExpression("groupSet/item", targetDepth)) {
                        groups.add(GroupIdentifierUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("instancesSet", targetDepth)) {
                        instances = new ArrayList<Instance>();
                        continue;
                    }
                    if (context.testExpression("instancesSet/item", targetDepth)) {
                        instances.add(InstanceUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("ownerId", targetDepth)) {
                        reservation.ownerId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("requesterId", targetDepth)) {
                        reservation.requesterId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("reservationId", targetDepth)) {
                        reservation.reservationId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("groupName", targetDepth)) {
                        groupNames = new ArrayList<String>();
                        continue;
                    }
                    if (!context.testExpression("groupName/GroupName", targetDepth)) continue;
                    groupNames.add(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            reservation.groups(groups);
            reservation.instances(instances);
            reservation.groupNames(groupNames);
        }
        return (Reservation)reservation.build();
    }

    public static ReservationUnmarshaller getInstance() {
        return INSTANCE;
    }
}

