/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.PurchaseHostReservationRequest;

public class PurchaseHostReservationRequestMarshaller
implements Marshaller<Request<PurchaseHostReservationRequest>, PurchaseHostReservationRequest> {
    public Request<PurchaseHostReservationRequest> marshall(PurchaseHostReservationRequest purchaseHostReservationRequest) {
        List<String> purchaseHostReservationRequestHostIdSetList;
        if (purchaseHostReservationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)purchaseHostReservationRequest, "EC2Client");
        request.addParameter("Action", "PurchaseHostReservation");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (purchaseHostReservationRequest.clientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)purchaseHostReservationRequest.clientToken()));
        }
        if (purchaseHostReservationRequest.currencyCodeAsString() != null) {
            request.addParameter("CurrencyCode", StringUtils.fromString((String)purchaseHostReservationRequest.currencyCodeAsString()));
        }
        if ((purchaseHostReservationRequestHostIdSetList = purchaseHostReservationRequest.hostIdSet()) != null) {
            int hostIdSetListIndex = 1;
            for (String purchaseHostReservationRequestHostIdSetListValue : purchaseHostReservationRequestHostIdSetList) {
                if (purchaseHostReservationRequestHostIdSetListValue != null) {
                    request.addParameter("HostIdSet." + hostIdSetListIndex, StringUtils.fromString((String)purchaseHostReservationRequestHostIdSetListValue));
                }
                ++hostIdSetListIndex;
            }
        }
        if (purchaseHostReservationRequest.limitPrice() != null) {
            request.addParameter("LimitPrice", StringUtils.fromString((String)purchaseHostReservationRequest.limitPrice()));
        }
        if (purchaseHostReservationRequest.offeringId() != null) {
            request.addParameter("OfferingId", StringUtils.fromString((String)purchaseHostReservationRequest.offeringId()));
        }
        return request;
    }
}

