/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.awscore.protocol.xml.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.awscore.protocol.xml.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.ec2.model.NatGateway;
import software.amazon.awssdk.services.ec2.model.NatGatewayAddress;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.transform.NatGatewayAddressUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.ProvisionedBandwidthUnmarshaller;
import software.amazon.awssdk.services.ec2.transform.TagUnmarshaller;

public class NatGatewayUnmarshaller
implements Unmarshaller<NatGateway, StaxUnmarshallerContext> {
    private static final NatGatewayUnmarshaller INSTANCE = new NatGatewayUnmarshaller();

    public NatGateway unmarshall(StaxUnmarshallerContext context) throws Exception {
        NatGateway.Builder natGateway;
        block16: {
            natGateway = NatGateway.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<NatGatewayAddress> natGatewayAddresses = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    natGateway.natGatewayAddresses(natGatewayAddresses);
                    natGateway.tags(tags);
                    break block16;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("createTime", targetDepth)) {
                        natGateway.createTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("deleteTime", targetDepth)) {
                        natGateway.deleteTime(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("failureCode", targetDepth)) {
                        natGateway.failureCode(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("failureMessage", targetDepth)) {
                        natGateway.failureMessage(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("natGatewayAddressSet", targetDepth)) {
                        natGatewayAddresses = new ArrayList<NatGatewayAddress>();
                        continue;
                    }
                    if (context.testExpression("natGatewayAddressSet/item", targetDepth)) {
                        natGatewayAddresses.add(NatGatewayAddressUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("natGatewayId", targetDepth)) {
                        natGateway.natGatewayId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("provisionedBandwidth", targetDepth)) {
                        natGateway.provisionedBandwidth(ProvisionedBandwidthUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("state", targetDepth)) {
                        natGateway.state(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("subnetId", targetDepth)) {
                        natGateway.subnetId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("vpcId", targetDepth)) {
                        natGateway.vpcId(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("tagSet", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("tagSet/item", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            natGateway.natGatewayAddresses(natGatewayAddresses);
            natGateway.tags(tags);
        }
        return (NatGateway)natGateway.build();
    }

    public static NatGatewayUnmarshaller getInstance() {
        return INSTANCE;
    }
}

