/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import software.amazon.awssdk.services.ec2.model.ModifyInstanceAttributeRequest;

public class ModifyInstanceAttributeRequestMarshaller
implements Marshaller<Request<ModifyInstanceAttributeRequest>, ModifyInstanceAttributeRequest> {
    public Request<ModifyInstanceAttributeRequest> marshall(ModifyInstanceAttributeRequest modifyInstanceAttributeRequest) {
        List<String> modifyInstanceAttributeRequestGroupsList;
        List<InstanceBlockDeviceMappingSpecification> modifyInstanceAttributeRequestBlockDeviceMappingsList;
        if (modifyInstanceAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)modifyInstanceAttributeRequest, "EC2Client");
        request.addParameter("Action", "ModifyInstanceAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyInstanceAttributeRequest.sourceDestCheck() != null) {
            request.addParameter("SourceDestCheck.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.sourceDestCheck()));
        }
        if (modifyInstanceAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyInstanceAttributeRequest.attributeAsString()));
        }
        if ((modifyInstanceAttributeRequestBlockDeviceMappingsList = modifyInstanceAttributeRequest.blockDeviceMappings()) != null) {
            int blockDeviceMappingsListIndex = 1;
            for (InstanceBlockDeviceMappingSpecification modifyInstanceAttributeRequestBlockDeviceMappingsListValue : modifyInstanceAttributeRequestBlockDeviceMappingsList) {
                EbsInstanceBlockDeviceSpecification ebs;
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.deviceName()));
                }
                if ((ebs = modifyInstanceAttributeRequestBlockDeviceMappingsListValue.ebs()) != null) {
                    if (ebs.deleteOnTermination() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.deleteOnTermination()));
                    }
                    if (ebs.volumeId() != null) {
                        request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeId", StringUtils.fromString((String)ebs.volumeId()));
                    }
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.noDevice()));
                }
                if (modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName() != null) {
                    request.addParameter("BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)modifyInstanceAttributeRequestBlockDeviceMappingsListValue.virtualName()));
                }
                ++blockDeviceMappingsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.disableApiTermination() != null) {
            request.addParameter("DisableApiTermination.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.disableApiTermination()));
        }
        if (modifyInstanceAttributeRequest.ebsOptimized() != null) {
            request.addParameter("EbsOptimized.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.ebsOptimized()));
        }
        if (modifyInstanceAttributeRequest.enaSupport() != null) {
            request.addParameter("EnaSupport.Value", StringUtils.fromBoolean((Boolean)modifyInstanceAttributeRequest.enaSupport()));
        }
        if ((modifyInstanceAttributeRequestGroupsList = modifyInstanceAttributeRequest.groups()) != null) {
            int groupsListIndex = 1;
            for (String modifyInstanceAttributeRequestGroupsListValue : modifyInstanceAttributeRequestGroupsList) {
                if (modifyInstanceAttributeRequestGroupsListValue != null) {
                    request.addParameter("GroupId." + groupsListIndex, StringUtils.fromString((String)modifyInstanceAttributeRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (modifyInstanceAttributeRequest.instanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceId()));
        }
        if (modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior() != null) {
            request.addParameter("InstanceInitiatedShutdownBehavior.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceInitiatedShutdownBehavior()));
        }
        if (modifyInstanceAttributeRequest.instanceType() != null) {
            request.addParameter("InstanceType.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.instanceType()));
        }
        if (modifyInstanceAttributeRequest.kernel() != null) {
            request.addParameter("Kernel.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.kernel()));
        }
        if (modifyInstanceAttributeRequest.ramdisk() != null) {
            request.addParameter("Ramdisk.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.ramdisk()));
        }
        if (modifyInstanceAttributeRequest.sriovNetSupport() != null) {
            request.addParameter("SriovNetSupport.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.sriovNetSupport()));
        }
        if (modifyInstanceAttributeRequest.userData() != null) {
            request.addParameter("UserData.Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.userData()));
        }
        if (modifyInstanceAttributeRequest.value() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyInstanceAttributeRequest.value()));
        }
        return request;
    }
}

