/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVolumeAttributeRequest;

public class DescribeVolumeAttributeRequestMarshaller
implements Marshaller<Request<DescribeVolumeAttributeRequest>, DescribeVolumeAttributeRequest> {
    public Request<DescribeVolumeAttributeRequest> marshall(DescribeVolumeAttributeRequest describeVolumeAttributeRequest) {
        if (describeVolumeAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeVolumeAttributeRequest, "EC2Client");
        request.addParameter("Action", "DescribeVolumeAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeVolumeAttributeRequest.attributeAsString() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)describeVolumeAttributeRequest.attributeAsString()));
        }
        if (describeVolumeAttributeRequest.volumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)describeVolumeAttributeRequest.volumeId()));
        }
        return request;
    }
}

