/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.ec2.model.CreateVpnConnectionRequest;
import software.amazon.awssdk.services.ec2.model.VpnConnectionOptionsSpecification;
import software.amazon.awssdk.services.ec2.model.VpnTunnelOptionsSpecification;

public class CreateVpnConnectionRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {
    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {
        VpnConnectionOptionsSpecification options;
        if (createVpnConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)createVpnConnectionRequest, "EC2Client");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRequest.customerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.customerGatewayId()));
        }
        if (createVpnConnectionRequest.type() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnConnectionRequest.type()));
        }
        if (createVpnConnectionRequest.vpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.vpnGatewayId()));
        }
        if ((options = createVpnConnectionRequest.options()) != null) {
            List<VpnTunnelOptionsSpecification> vpnConnectionOptionsSpecificationTunnelOptionsList;
            if (options.staticRoutesOnly() != null) {
                request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean((Boolean)options.staticRoutesOnly()));
            }
            if ((vpnConnectionOptionsSpecificationTunnelOptionsList = options.tunnelOptions()) != null) {
                int tunnelOptionsListIndex = 1;
                for (VpnTunnelOptionsSpecification vpnConnectionOptionsSpecificationTunnelOptionsListValue : vpnConnectionOptionsSpecificationTunnelOptionsList) {
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.tunnelInsideCidr() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".TunnelInsideCidr", StringUtils.fromString((String)vpnConnectionOptionsSpecificationTunnelOptionsListValue.tunnelInsideCidr()));
                    }
                    if (vpnConnectionOptionsSpecificationTunnelOptionsListValue.preSharedKey() != null) {
                        request.addParameter("Options.TunnelOptions." + tunnelOptionsListIndex + ".PreSharedKey", StringUtils.fromString((String)vpnConnectionOptionsSpecificationTunnelOptionsListValue.preSharedKey()));
                    }
                    ++tunnelOptionsListIndex;
                }
            }
        }
        return request;
    }
}

