/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.ec2.EC2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Reservation;

public class DescribeInstancesIterable
implements SdkIterable<DescribeInstancesResponse> {
    private final EC2Client client;
    private final DescribeInstancesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeInstancesIterable(EC2Client client, DescribeInstancesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeInstancesResponseFetcher();
    }

    public Iterator<DescribeInstancesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final SdkIterable<Reservation> reservations() {
        Function<DescribeInstancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservations() != null) {
                return response.reservations().iterator();
            }
            return Collections.emptyIterator();
        };
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    public final DescribeInstancesIterable resume(DescribeInstancesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeInstancesIterable(this.client, (DescribeInstancesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeInstancesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<DescribeInstancesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class DescribeInstancesResponseFetcher
    implements SyncPageFetcher<DescribeInstancesResponse> {
        private DescribeInstancesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeInstancesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeInstancesResponse nextPage(DescribeInstancesResponse previousPage) {
            if (previousPage == null) {
                return DescribeInstancesIterable.this.client.describeInstances(DescribeInstancesIterable.this.firstRequest);
            }
            return DescribeInstancesIterable.this.client.describeInstances((DescribeInstancesRequest)((Object)DescribeInstancesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

