/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeAttachment;
import software.amazon.awssdk.services.ec2.model.VolumeAttachmentListCopier;
import software.amazon.awssdk.services.ec2.model.VolumeState;
import software.amazon.awssdk.services.ec2.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Volume
implements ToCopyableBuilder<Builder, Volume> {
    private final List<VolumeAttachment> attachments;
    private final String availabilityZone;
    private final Instant createTime;
    private final Boolean encrypted;
    private final String kmsKeyId;
    private final Integer size;
    private final String snapshotId;
    private final String state;
    private final String volumeId;
    private final Integer iops;
    private final List<Tag> tags;
    private final String volumeType;

    private Volume(BuilderImpl builder) {
        this.attachments = builder.attachments;
        this.availabilityZone = builder.availabilityZone;
        this.createTime = builder.createTime;
        this.encrypted = builder.encrypted;
        this.kmsKeyId = builder.kmsKeyId;
        this.size = builder.size;
        this.snapshotId = builder.snapshotId;
        this.state = builder.state;
        this.volumeId = builder.volumeId;
        this.iops = builder.iops;
        this.tags = builder.tags;
        this.volumeType = builder.volumeType;
    }

    public List<VolumeAttachment> attachments() {
        return this.attachments;
    }

    public String availabilityZone() {
        return this.availabilityZone;
    }

    public Instant createTime() {
        return this.createTime;
    }

    public Boolean encrypted() {
        return this.encrypted;
    }

    public String kmsKeyId() {
        return this.kmsKeyId;
    }

    public Integer size() {
        return this.size;
    }

    public String snapshotId() {
        return this.snapshotId;
    }

    public VolumeState state() {
        return VolumeState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String volumeId() {
        return this.volumeId;
    }

    public Integer iops() {
        return this.iops;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public String volumeTypeAsString() {
        return this.volumeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachments());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.createTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Volume)) {
            return false;
        }
        Volume other = (Volume)obj;
        return Objects.equals(this.attachments(), other.attachments()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.createTime(), other.createTime()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.snapshotId(), other.snapshotId()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.volumeId(), other.volumeId()) && Objects.equals(this.iops(), other.iops()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString());
    }

    public String toString() {
        return ToString.builder((String)"Volume").add("Attachments", this.attachments()).add("AvailabilityZone", (Object)this.availabilityZone()).add("CreateTime", (Object)this.createTime()).add("Encrypted", (Object)this.encrypted()).add("KmsKeyId", (Object)this.kmsKeyId()).add("Size", (Object)this.size()).add("SnapshotId", (Object)this.snapshotId()).add("State", (Object)this.stateAsString()).add("VolumeId", (Object)this.volumeId()).add("Iops", (Object)this.iops()).add("Tags", this.tags()).add("VolumeType", (Object)this.volumeTypeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Attachments": {
                return Optional.of(clazz.cast(this.attachments()));
            }
            case "AvailabilityZone": {
                return Optional.of(clazz.cast(this.availabilityZone()));
            }
            case "CreateTime": {
                return Optional.of(clazz.cast(this.createTime()));
            }
            case "Encrypted": {
                return Optional.of(clazz.cast(this.encrypted()));
            }
            case "KmsKeyId": {
                return Optional.of(clazz.cast(this.kmsKeyId()));
            }
            case "Size": {
                return Optional.of(clazz.cast(this.size()));
            }
            case "SnapshotId": {
                return Optional.of(clazz.cast(this.snapshotId()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "VolumeId": {
                return Optional.of(clazz.cast(this.volumeId()));
            }
            case "Iops": {
                return Optional.of(clazz.cast(this.iops()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
            case "VolumeType": {
                return Optional.of(clazz.cast(this.volumeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<VolumeAttachment> attachments;
        private String availabilityZone;
        private Instant createTime;
        private Boolean encrypted;
        private String kmsKeyId;
        private Integer size;
        private String snapshotId;
        private String state;
        private String volumeId;
        private Integer iops;
        private List<Tag> tags;
        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(Volume model) {
            this.attachments(model.attachments);
            this.availabilityZone(model.availabilityZone);
            this.createTime(model.createTime);
            this.encrypted(model.encrypted);
            this.kmsKeyId(model.kmsKeyId);
            this.size(model.size);
            this.snapshotId(model.snapshotId);
            this.state(model.state);
            this.volumeId(model.volumeId);
            this.iops(model.iops);
            this.tags(model.tags);
            this.volumeType(model.volumeType);
        }

        public final Collection<VolumeAttachment.Builder> getAttachments() {
            return this.attachments != null ? (Collection)this.attachments.stream().map(VolumeAttachment::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder attachments(Collection<VolumeAttachment> attachments) {
            this.attachments = VolumeAttachmentListCopier.copy(attachments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(VolumeAttachment ... attachments) {
            this.attachments(Arrays.asList(attachments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attachments(Consumer<VolumeAttachment.Builder> ... attachments) {
            this.attachments(Stream.of(attachments).map(c -> (VolumeAttachment)((VolumeAttachment.Builder)VolumeAttachment.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAttachments(Collection<VolumeAttachment.BuilderImpl> attachments) {
            this.attachments = VolumeAttachmentListCopier.copyFromBuilder(attachments);
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final Instant getCreateTime() {
            return this.createTime;
        }

        @Override
        public final Builder createTime(Instant createTime) {
            this.createTime = createTime;
            return this;
        }

        public final void setCreateTime(Instant createTime) {
            this.createTime = createTime;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        @Override
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        public final Integer getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Integer size) {
            this.size = size;
            return this;
        }

        public final void setSize(Integer size) {
            this.size = size;
        }

        public final String getSnapshotId() {
            return this.snapshotId;
        }

        @Override
        public final Builder snapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
            return this;
        }

        public final void setSnapshotId(String snapshotId) {
            this.snapshotId = snapshotId;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(VolumeState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getVolumeId() {
            return this.volumeId;
        }

        @Override
        public final Builder volumeId(String volumeId) {
            this.volumeId = volumeId;
            return this;
        }

        public final void setVolumeId(String volumeId) {
            this.volumeId = volumeId;
        }

        public final Integer getIops() {
            return this.iops;
        }

        @Override
        public final Builder iops(Integer iops) {
            this.iops = iops;
            return this;
        }

        public final void setIops(Integer iops) {
            this.iops = iops;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().apply((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType.toString());
            return this;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        public Volume build() {
            return new Volume(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Volume> {
        public Builder attachments(Collection<VolumeAttachment> var1);

        public Builder attachments(VolumeAttachment ... var1);

        public Builder attachments(Consumer<VolumeAttachment.Builder> ... var1);

        public Builder availabilityZone(String var1);

        public Builder createTime(Instant var1);

        public Builder encrypted(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder size(Integer var1);

        public Builder snapshotId(String var1);

        public Builder state(String var1);

        public Builder state(VolumeState var1);

        public Builder volumeId(String var1);

        public Builder iops(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);
    }
}

